package cn.smarthse.modules.eduTraining.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Comments:  <精准培训试题>
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2022/2/9-16:50
*/
@ApiModel(value="精准培训试题", description="精准培训试题")
public @Data class ExamQuestionModel implements Serializable {


	@ApiModelProperty(value = "试题id")
	private Long questionId;


	@ApiModelProperty(value = "题干")
	private String title;


	@ApiModelProperty(value = "试题类别（1、单选 2、多选 3、填空）")
	private Integer questionType;

	@ApiModelProperty(value = "试题类别为填空时， 答案的字个数")
	private Integer textNum = 0;


	@ApiModelProperty(value = "解析")
	private String analysis;


	@ApiModelProperty(value = "选择题-选项列表")
	List<ExamQuestionAnswerModel> answerItem = new ArrayList<>();

}
