package cn.smarthse.modules.eduTraining.model;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class ExamLogRecordModel implements Serializable {

    /**
     *
     */
    private Long id;
    /**
     * 考试时间与人员关联表id
     */
    private Long timeMemberId;

    /**
     * 考试时间表id
     */
    private Long timeId;

    /**
     * 人员表id
     */
    private Long trainingMemberId;

    /**
     * 考试类别（1-预考核 2-在线考试 3-线下考试）
     */
    private String examType;
    /**
     * 角色（1-主要负责人 2-职业卫生管理人员 3-劳动者）
     */
    private Integer role;
    /**
     * 状态（0、未开始 1、未通过，2、已通过）
     */
    private String state;
    /**
     * 分数
     */
    private Integer score;
    /**
     * 开始答题时间
     */
    private LocalDateTime beginTime;
    /**
     * 结束答题时间
     */
    private LocalDateTime endTime;
    /**
     * 是否有效
     */
    private Boolean isValid;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 创建日期
     */
    private LocalDateTime createDate;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 更新日期
     */
    private LocalDateTime updateDate;
}
