package cn.smarthse.modules.eduTraining.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName TrainingVideoMemberModel
 * @Description 用户视频课程学习情况
 * @Author Wuxq
 * @Date 2021/1/27
 */
public @Data class EduTrainingVideoMemberModel implements Serializable {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "用户id")
    private Long memberId;

    @ApiModelProperty(value = "视频课程名称")
    private String videoName;

    @ApiModelProperty(value = "视频课程")
    private String videoFile;

    @ApiModelProperty(value = "视频课程图片")
    private String videoImage;

    @ApiModelProperty(value = "视频学习状态")
    private Integer status;

    @ApiModelProperty(value = "视频学习状态")
    private String statusStr;

    @ApiModelProperty(value = "对应学时")
    private BigDecimal learnHour;

    @ApiModelProperty(value = "视频时长")
    private Long videoTime;

    @ApiModelProperty(value = "已学习时长(单位为秒)")
    private Integer learnTime;

}
