package cn.smarthse.modules.datacentre.provider.zlb;

import cn.smarthse.modules.datacentre.model.zlb.ZlbUserInfo;

/**
 *
 * 浙里办用户接口
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2024/6/20 15:01
 */
public interface IZlbUserInfoProviderService {

    /**
     * 获取浙里办用户信息
     * @param zlbUserId 浙里办用户id
     * @param userType 浙里办用户类型 用户类型，PERSON个人/LEGAL_PERSON法人
     * @return {@link ZlbUserInfo}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/20 15:03
     */
    ZlbUserInfo getUserInfo(String zlbUserId, String userType);
    /**
     * 保存浙里办用户信息
     * @param zlbUserInfo： PersonInfo 或者 legalPersonInfo
     * @return {@link null}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/20 15:04
     */
    void saveZlbUserInfo(ZlbUserInfo zlbUserInfo);
}
