package cn.smarthse.modules.datacentre.provider.system.riskFactors;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmSeachModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoSeachModel;

/**
 * 危害因素服务-提供给平台
 * @Description 
 * @Author liaoly
 * @Date 2020年4月7日 下午2:06:37
 */
public interface IRiskFactorsProvideByPlatformService {
	
	/**
	 * 分页查询危害因素限值
	 * @param seach
	 * @return
	 */
	PageInfo<HarmModel> getHazardListByHXFC(HarmSeachModel seach);
	
	/**
	 * 根据类型查询危害因素列表
	 * @param type HaezrdTypeEnum
	 * @return
	 */
	List<HarmModel> getListByType(String type);
	
	/**
	 * 根据首字母查询列表
	 * @param initials 首字母(大写)
	 * @return
	 */
	List<HarmModel> getListByInitials(String initials,String type,String keyword);
	
	/**
	 * 根据id查询model
	 * @param id
	 * @return
	 */
	HarmModel getModelById(Long id);
	
	/**
	 * 查询危害因数
	 * @param harmId : 危害因素id
	 * @return
	 */
	HarmInfoModel getHarmInfoById(HarmInfoSeachModel model);
	
	/**
	 * 查询GBZ2.1的危害因素
	 * @return
	 */
	List<HarmModel> getListByGBZ(String type,String keyword);
}
