package cn.smarthse.modules.datacentre.provider.system.riskFactors;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.datacentre.model.platformAdmin.search.RiskFactorSearchModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.OccupationalRiskFactorsModel;

/**
 * 危害因素服务-提供给运营后台
 * @Description 
 * @Author liaoly
 * @Date 2020年4月7日 下午2:06:37
 */
public interface IRiskFactorsProvideByPlatformAdminService {
	
	/**
	 * 查询危害因素列表-提供给运营后台的
	 * @param param : 综合查询参数对象
	 * @return
	 */
	public List<OccupationalRiskFactorsModel> getRiskFactorsList(RiskFactorSearchModel param);
	
	/**
	 * 查询危害因素列表(分页)-提供给运营后台的
	 * @param param : 综合查询参数对象
	 * @return
	 */
	public PageInfo<OccupationalRiskFactorsModel> getRiskFactorsListData(RiskFactorSearchModel param);
	
	/**
	 * 查询危害因素详情
	 * @param id : 危害因素id
	 * @return
	 */
	public OccupationalRiskFactorsModel getRiskFactors(Long id);
	
	/**
	 * 新增危害因素
	 * @param occupationalRiskFactorsModel : 危害因素model
	 * @param adminId : 操作账号id
	 */
	public void addRiskFactors(OccupationalRiskFactorsModel occupationalRiskFactorsModel, Long adminId);
	
	/**
	 * 编辑保存危害因素
	 * @param occupationalRiskFactorsModel : 危害因素model
	 * @param adminId : 操作账号id
	 */
	public void saveRiskFactors(OccupationalRiskFactorsModel occupationalRiskFactorsModel, Long adminId);
	
	/**
	 * 删除危害因素
	 * @param id : 危害因素id
	 * @param adminId : 操作账号id
	 */
	public void delRiskFactors(Long id, Long adminId);
	
	/**
	 * 更新危害因素是否显示字段
	 * @param id : 危害因素
	 * @param isShow : 是否显示(1/true显示，0/false不显示)
	 * @param adminId
	 */
	public void saveIsShowRiskFactors(Long id, Boolean isShow, Long adminId);
	
	/**
	 * 更新拼音字段
	 * @param record
	 */
	public void updatePy(OccupationalRiskFactorsModel record);
}