package cn.smarthse.modules.datacentre.provider.system.riskFactors;

import cn.smarthse.modules.datacentre.model.harmfactor.DcHarmFactorQueryModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.FactorAttr;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor;

import java.util.List;
import java.util.Map;



public interface IHarmFactorService  {
	public HarmFactor getOccupationalRiskFactorsAutoCompleteByNameCh(String type,String name,Long cid) ;

	public HarmFactor getOccupationalRiskFactorsAutoCompleteByBlendName(String type, String name, Long cid);

	public List<HarmFactor> getOccupationalRiskFactorsListByCid(String type, String searchKey, Long cid);

	public List<HarmFactor> getOccupationalRiskFactors(String type, String searchKey,Long cid);

	public List<HarmFactor> getHarmByIds(String ids);

	public String getHarmIdsByNames(String harmNames);

	public Map<Boolean, HarmFactor> addOtherHarmFactorSubmit(HarmFactor factors, Long userId, Long cid);

	/**
	 * @Comments:  <重写上面的方法，  >
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/6/13-13:59
	 * @param factors
	 * @param userId
	 * @param cid
	 * @param isRiskEvAdd	新增参数，  如果是暴露风险 需要判断 是否属于 2019和2007
	 * @return java.util.Map<java.lang.Boolean,cn.smarthse.modules.datacentre.model.system.riskFactors.HarmFactor>
	*/
	public Map<Boolean, HarmFactor> addOtherHarmFactorSubmit(HarmFactor factors, Long userId, Long cid, boolean isRiskEvAdd);

	public void deleteOtherOccupationalRiskFactorsById(Long id);

	public Long getOrAddHarmIdByName(String harmName,Long cid,String harmType,Long creator);

	public String getHarmIdsByNames(String harmNames,Map<String,Long> existHarm,Long cid,String harmType,Long creator);

	List<HarmFactor>  getHarmByNameAndCid(String nameCh, String customerNameCh,Long cid);

	List<HarmFactor>  getByHarm(HarmFactor harm);

	void addCustomHarm(HarmFactor factor, Long userId);

	Map<String, HarmFactor> getAllMap(Long cid);

	Map<String, List<HarmFactor>> getAllMap();

	Map<String, String> getAllIdAndNameMap();

	Map<String, String> getAllIdAndNameMapForCheckPlan();

	/**
	 * 包括已删除的
	 * @return
	 */
	Map<String, String> getAllIdAndNameMapIncludeInValid();

	Map<String, String> getAllIdAndNameMapIncludeInValid2007();

	Map<String, String> getAllIdAndNameMapIncludeInValid2019();

	Map<String, String> getAllNameAndIdMap();

	Map<String, String> getAllNameAndIdMap2007();

	Map<String, String> getAllNameAndIdMap2019();

	Map<String, String> getAllNameAndIdMap2007(Long cid);

	public Map<String, String> getAllNameAndIdMap2007ContailRay(Long cid);

	Map<String, String> getAllNameAndIdMap2019(Long cid);
	Map<String, String> getAllNameAndIdMap2019ContailRay(Long cid);


	HarmFactor addByNameAndType(String harmName,String harmType,Long cid,Long creator);

	/**
	 *
	 * @param type
	 * @param searchKey
	 * @param cid
	 * @param gbz22007 0、体检 1、检测/评价
	 * @return
	 */
	public List<HarmFactor> getOccupationalRiskFactors(String type, String searchKey,Long cid,int gbz22007);

	/**
	 * 查询危害因数的限值
	 * @param factorIds
	 * @return
	 */
	List<FactorAttr> getByFactorIds(List<Long> factorIds);

	public void updateById(HarmFactor harmFactor, Long creator);

	public HarmFactor getThisById(Long id);

	public String getHarmNames(String harmIds);

	/**
	 * 获取a-z排序后的结果集，如有搜索关键字，返回首先根据关键字位置排序、其次根据除关键字外的首字母排序、再根据名称长度排序后的结果集
	 * @author haosw
	 * @date 2020/9/24 15:41
	 * @param harm: 
	 * @return
	*/
	Map<String, List<HarmFactor>>  getSortByHarm(HarmFactor harm);

	/**
	 * 检测模块 危害因素查询
	 * @param harm
	 * @param standardId
	 * @return
	 */
	Map<String, List<HarmFactor>>  getCheckFactorSortByHarm(HarmFactor harm, Long standardId);

	/**
	 * 	获取危害因素2007和2019的合集
	 * @param harm
	 * @return
	 */
	Map<String, List<HarmFactor>> getUnionFactorSortByHarm(HarmFactor harm);

	List<HarmFactor> getByHazardRating(String hazardRating);

    List<String>  getTypes();

    HarmFactor addHarm(HarmFactor dicValue);

    boolean isSameHarmName(String nameCh, Long id);

    boolean isSameParamCode(String paramcode, Long id);

     List<HarmFactor> getHarmFactorListBySearch(String type,Integer status, String searchKey);

    HarmFactor updateHarm(HarmFactor dicValue);

    void showOrHide(Integer flag, Long id,Long loginStaffId);

    /**
     *获取所有id及对应类型
    */
	public Map<Long, String> doGetAllIdAndTypeMap();

	/**
	 *获取所有id及对应类型
	 */
	public Map<Long, String> doGetAllIdAndTypeFactorMap();

	/*
	 * @Description:根据名称获取危害因素类型
	 * @Author: XiaoYi(肖奕)
	 * @Date: 2021/5/25 9:01
	 * @param: [harmName]
	 * @return: java.lang.String
	 **/
	String getTypeByName(String harmName);

    String getHarmIdsForApiByNames(String harmNames);


	public List<HarmFactor> selectList(Long cid, String keyword, String harmTypes);

	public List<HarmFactor> selectListByQueryModel(DcHarmFactorQueryModel dcHarmFactorQueryModel);
	List<HarmFactor> getHarmFactorsForInvestigation( String searchKey, Long cid);

	/**
	 * 获取危害因素性质
	 * @return
	 */
	Map<Long, String> getFactorNature();

	/**
	 * 根据首字母查询列表
	 * @param initials 首字母(大写)
	 * @return
	 */
	List<HarmModel> getListByInitials(String initials, String type, String keyword);

	List<HarmFactor> getAllListIncludeInvalid();
}
