package cn.smarthse.modules.datacentre.provider.system;

import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import com.github.pagehelper.PageInfo;

import java.io.IOException;
import java.util.List;

/**
 * 四级行业
 *
 * @Description
 * @Author liaoly
 * @Date 2019年12月31日 下午5:04:33
 */
public interface IndustryProvideService {

    /**
     * 查询指定行业的直接下级行业列表
     *
     * @param parentId
     * @return
     */
    List<IndustryModel> getIndustryListByPid(Long parentId);

    /**
     * 模糊查询
     *
     * @param pageNum
     * @param pageSize
     * @param keyword
     * @return
     */
    PageInfo<IndustryModel> getIndustryList(Integer pageNum, Integer pageSize, String keyword);

    /**
     * 模糊查询第4级的行业列表
     * @param keyword 关键字
     * @return {@link List<IndustryModel>}
     * @author liaoly
     * @date 2023/3/13 13:47
     */
    List<IndustryModel> searchIndustryList4(String keyword);

    public List<IndustryModel> searchIndustryList(String keyword, String code);

    /**
     * 得到所有的行业集合
     *
     * @return
     */
    public List<IndustryModel> getIndustryList();

    public List<IndustryModel> getIndustryByIds(String ids);

    /**
     * 新增四级行业信息
     *
     * @param industryModel : 系统参数对象
     * @param adminId    : 操作账号id
     */
    void addIndustry(IndustryModel industryModel, Long adminId);

    /**
     * 保存四级行业
     *
     * @param industryModel
     * @param adminId
     */
    void saveIndustry(IndustryModel industryModel, Long adminId);

    /**
     * 删除四级行业
     *
     * @param industryId : 四级行业id
     * @param adminId    : 操作账号id
     */
    void delIndustry(Long industryId, Long adminId);

    /**
     * 排序, 当前Industry和上/下一个交换sort值. 排序字段为sort asc
     *
     * @param code:    行业编码
     * @param upOrDwon : 上移还是下移(上移:-1; 下移: 1)
     * @param adminId  : 操作账号id
     */
    public void sortIndustry(String code, Integer upOrDwon, Long adminId);

    /**
     * 导入四级行业(dao层没有实现，不建议导入)
     * <li>注:只支持".xls"excel文件
     *
     * @param fileId  : 上传的excel文件id
     * @param adminId : 操作账号id
     * @return 有错误信息返回List<Stirng>对象，没有则返回null
     */
    List<String> importIndustry(Long fileId, Long adminId) throws IOException;

    IndustryModel getIndustryById(Long id);

    /**
     * 查询指定编码的四级行业
     *
     * @param code
     * @return
     */
    @Deprecated
    IndustryModel getIndustryByCode(String code);

    /**
     * 查询指定编码的四级行业【因为存在同一编码，但有多个行业的情况，故取sub_code字段】
     *
     * @param code
     * @return cn.smarthse.modules.datacentre.model.system.IndustryModel
     * @author ShenZQ
     * @since 2022/11/21 13:57
     */
    IndustryModel getIndustryBySubCode(String code);

    public List<IndustryModel> getIndustryListByNames(String induNames);

    public IndustryModel getIndustryByName(String induName);

    public List<IndustryModel> getIndustryChildList(Long parentId, String keyword);

    /**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return
     */
    List<SysParamModel> getListByIds(String ids);
}
