package cn.smarthse.modules.datacentre.provider.system;

import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.modules.platform.model.SuperviseVirtualAreaModel;

/**
*
* 虚拟地区接口
*
* @author wujiacheng
* @since 2022-7-7
*/
public interface ISysVirtualAreaProvideService {

    /**
     * 根据 ID 获取虚拟地区
     * @param id
     * @return
     */
    SuperviseVirtualAreaModel getById(Long id);

    /**
     * 隐藏或显示虚拟区域
     * @param areaId
     * @param show
     * @param loginStaffId
     * @return
     */
    int showOrHide(Long areaId, Boolean show, Long loginStaffId);

    /**
     * 新增或更新虚拟地区
     * @param model
     * @param loginStaffId
     * @return
     */
    SuperviseAreaModel addOrUpdateBySupervise(SuperviseAreaModel model, Long loginStaffId) throws Exception;

}
