package cn.smarthse.modules.datacentre.provider.system;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;

import java.io.File;
import java.util.List;

/**
 * 数据中心-系统附件服务service
 *
 * @Description
 * @Author liaoly
 * @Date 2020年3月2日 上午10:19:47
 */
public interface ISysFileProvideService {

    /**
     * 根据文件id查询文件详情
     *
     * @param fileId : 文件id
     * @return
     */
    SysFileModel getFileById(Long fileId);

    /**
     * 该方法与getFileById 唯一区别：调整了 setOssUrl 属性值（项目中需要相对路径的从ossUrl属性中获取，全路径从FullOssUrl获取， 避免都设置成一样的）
     */
    public SysFileModel getSmartHseFileById(Long fileId);

    /**
     * 根据文件hash值获取文件
     *
     * @param filehash : 文件hash值
     * @return
     */
    SysFileModel getFileByHash(String filehash);

    /**
     * 根据文件Id获得文件全路径地址
     *
     * @param fileId : 文件id
     * @return
     */
    String getFileUrl(Long fileId);

    /**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return
     */
    List<SysFileModel> getListByIds(String ids);


    List<SysFileModel> getListByIds(List<Long> ids);

    /**
     * 通用的文件上传接口
     *
     * @param record  : 文件对象
     * @param adminId : 操作账号id，可为空
     * @return
     */
    SysFileModel addSysFile(SysFileModel record, Long adminId);

    /**
     * 通用的文件上传接口
     *
     * @param record  : 文件对象
     * @param adminId : 操作账号id，可为空
     * @param cid     :cid
     * @return
     */
    SysFileModel addSysFile(SysFileModel record, Long adminId, Long cid);

    /**
     * 通用的文件上传接口
     *
     * @param cid      : 文件对象
     * @param filehash : 文件hashId
     * @param cid      :cid
     * @return
     */
    SysFileModel getFileByCid(Long cid, String filehash);

    SysFileModel getFileByUrl(String url);

    SysFileModel addFile(Long cid, String fileName, File file, String ossUrl);

    Long sumSpaceByCid(Long cid);

    /**
     * @param outOssUrl
     * @return java.lang.String  我们的oss地址
     * @Comments: <从第三方地址下载并上传到我们的oss 服务中，>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2024/2/28-16:26
     */
    public String uploadOutUrlFile2Oss(String outOssUrl) throws Exception;

    public String uploadOutUrlFile2OssMore(String outOssUrlsMore, String splitStr) throws Exception;

    /**
     * @param fileIds
     * @param copyNewFile 是否新增一个oss 文件， false:继续用之前的oss地址 只是file多新增一条数据
     * @return java.lang.Long
     * @Comments: <拷贝oss文件>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2024/3/29-15:52
     */
    public List<Long> cloneFile(String fileIds, boolean copyNewFile);

    /**
     * @param fileIds
     * @return void
     * @Comments: <附件删除操作>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2024/7/2-16:08
     */
    public void delFile(String fileIds, Long updateBy);


    public void updateRecycleFlag(Integer recycleFlag, List<Long> fileIds);

}
