package cn.smarthse.modules.datacentre.provider.system;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.SuperviseAreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.*;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 《DC 系统参数Service》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @since 2017-07-08 02:44
 */
public interface ISysAreaProvideService {

    /**
     * 根据区域ID前缀读取行政区域 列表
     *
     * @param prefix 例如 33开头的,即读取所有浙江的行政区域数据
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2017-7-17-下午2:03:53
     */
    List<AreaModel> getChildByPrefix(String prefix);

    /**
     * 查询区域详情
     *
     * @param areaId
     * @return
     */
    public AreaModel getAreaById(Long areaId);

    /**
     * @param areaId
     * @param connector 分隔符
     * @description: 获取区域全称
     * @author: chenliang
     * @date: 2023/9/26 10:53
     * @return: {@link String}
     */
    public String getFullAreaName(Long areaId, String connector);

    public String getFullName(Long areaId, String separation);
    /**
     * 查询区域列表
     *
     * @param areaIds : 区域ids
     * @return
     */
    public List<AreaModel> getAreaListByIds(String areaIds);

    /**
     * 查询所有省
     *
     * @return
     */
    List<AreaModel> getAllProvinceList();

    List<AreaModel> getAllProvinceList(String areaIds);

    /**
     * 查询指定省的所有市
     *
     * @param provinceId : 省id
     * @return
     */
    List<AreaModel> getCityList(Long provinceId);

    List<AreaModel> getCityList(Long provinceId, String areaIds);

    /**
     * 查询指定市的所有区
     *
     * @param cityId : 市id
     * @return
     */
    List<AreaModel> getAreaList(Long cityId);

    List<AreaModel> getAreaList(Long cityId, String areaIds);

    /**
     * 查询指定区的所有街道
     *
     * @param areaId : 区id
     * @return
     */
    List<AreaModel> getStreetList(Long areaId);

    List<AreaModel> getStreetList(Long areaId, String areaIds);

    /**
     * 条件查询区域
     *
     * @param parentId : 父id
     * @param name     : 区域名
     * @return
     */
    List<AreaModel> getChildByParentId(Long parentId, String name);

    List<AreaModel> getProvinceAllById(Long provinceId);

    Integer getCountChildByPid(Long pid);

    Map<Long, Map<String, Long>> getCountChildByPids(List<Long> pids);

    /**
     * 根据父Id 读取 所有叶子节点的Id
     *
     * @param parentId
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2019年8月6日-上午9:54:12
     */
    public List<Long> getAreaIdByParent(Long parentId);

    AreaModel getAreaByName(Long parentId, String areaName);

    public AreaModel centerAreaInfo(Long areaId, Byte areaLevel, Long centerAreaId);

    /**
     * 添加区域
     *
     * @param areaModel
     * @param adminId   : 操作账号id
     */
    public void addArea(AreaModel areaModel, Long adminId);

    /**
     * 编辑行政区域, 不更新各级的xxxName冗余字段
     *
     * @param areaModel : 行政区域对象
     * @param adminId   : 操作账号id
     */
    public void saveArea(AreaModel areaModel, Long adminId);

    /**
     * 删除行政区域
     *
     * @param id
     * @param adminId : 操作账号id
     */
    public void delArea(Long id, Long adminId);

    /**
     * 排序, 当前area和上/下一个交换sort值. 排序字段为sort asc
     *
     * @param id       : 区域id
     * @param upOrDwon : 上移还是下移(上移:-1; 下移: 1)
     * @param adminId  : 操作账号id
     */
    public void sortArea(Long id, Integer upOrDwon, Long adminId);

    /**
     * 模糊查询, 分页
     *
     * @param pageNum  : 起始页
     * @param pageSize : 每页显示几条数据
     * @param keyword  : 关键字
     * @return
     */
    public PageInfo<AreaModel> getAreaListData(Integer pageNum, Integer pageSize, String keyword);

    public AreaModel getAreaByName(String areaName);

    public Map<Long, AreaModel> getAreaMap();

    public List<SuperviseAreaModel> listAllArea(SuperviseAreaModel areaModel);

    public List<AreaModel> getProvCityAreaList(SuperviseAreaModel areaModel);

    /**
     * 获取子级节点
     *
     * @param areaModel
     * @return java.util.List<cn.smarthse.modules.platform.model.SuperviseAreaModel>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/15-16:45
     */
    public List<SuperviseAreaModel> getChildOrSearch(SuperviseAreaModel areaModel);

    /**
     * 获取子级节点，排除删除或隐藏数据
     *
     * @param areaModel
     * @return {@link List<SuperviseAreaModel>}
     * @author ShenZQ
     * @since 2023/3/14 9:24
     */
    public List<SuperviseAreaModel> getChildOrSearchExcludeDeleteOrHide(SuperviseAreaModel areaModel);

    /**
     * @param areaId
     * @param show
     * @param loginStaffId
     * @return int
     * @Comments: <更新行政区划信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/16-11:33
     */
    public int showHideCascChild(Long areaId, Boolean show, Long loginStaffId);

    /**
     * @param model
     * @param loginStaffId
     * @return cn.smarthse.modules.platform.model.SuperviseAreaModel
     * @Comments: <新增或修改 行政区划 信息>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/16-15:07
     */
    public SuperviseAreaModel addOrUpdateBySupervise(SuperviseAreaModel model, Long loginStaffId);

    public SuperviseAreaModel getSuperviseAreaById(Long areaId);

    /**
     * 判断给定的区域ID 是否在监管范围内
     *
     * @param areaId    要判定的areaId
     * @param orgAreaId 监管areaId
     * @return boolean
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/30-9:32
     */
    public boolean containAuthArea(Long areaId, Long orgAreaId);

    /**
     * 获取根据区域名称 构建的区域map
     *
     * @param
     * @return java.util.Map<java.lang.String, cn.smarthse.modules.platform.model.AreaModel>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/30-10:14
     */
    public Map<String, AreaModel> getAreaNameMap();

    /**
     * 根据地区关键字模糊查询地区列表
     *
     * @param keyword : 关键字
     * @param level   : 级别（小于）
     * @author wujiacheng
     * @since 2022-7-12
     */
    List<AreaModel> getByAreaName(String keyword, Byte level, AreaModel areaModel);

    void resetAreaSortByPid(Long pid, Long loginStaffId);

    /**
     * 根据区域id 和区域level 获取该区域下的所有区域id
     *
     * @param areaId
     * @param level
     * @return
     */
    public List<Long> getAllAreaIdByParentAndLevel(Long areaId, Integer level);

    /*
     * @Description:根据上级区域查询制定层级的所有下级区域
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/11/17 9:34
     * @param: [areaId, resLevel, areaLevle][上级区域id，返回区域层级，参数区域层级]
     * @return: java.util.List<cn.smarthse.modules.platform.model.AreaModel>
     **/
    List<AreaModel> getListByLevel(Long areaId, Byte resLevel, Byte areaLevel);

    /**
     * 获取所有区域，树结构-V3
     */
    Tree<String> getAllAreaTreeV3(SysAreaV3TreeParam param);

    /**
     * 获取下一级区域,含子级，树结构-V3
     */
    Tree<String> getNextLevelAreaTreeV3(SysAreaV3TreeParam param);

    /**
     * 获取所有区域-V3
     */
    List<SysAreaV3ListVo> getAllAreaV3();

    Map<Long, AreaModel> getAreaMapByIdList(List<Long> idList);

    /**
     * 查询下级行政区划列表-V3
     */
    List<SysAreaV3ListVo> getNextLevelAreaListByParentIdV3(SysAreaV3Param param);

    /**
     * 查询单个行政区划-V3
     */
    SysAreaV3OneVo getAreaByIdV3(Long id);

    /**
     * 保存-V3
     */
    Boolean saveV3(SysAreaV3AddParam param);

    /**
     * 更新-V3
     */
    Boolean updateV3(SysAreaV3EditParam param);

    /**
     * 显示或隐藏-V3
     */
    Boolean showOrHideV3(SysAreaV3ShowOrHideParam param);

    Map<String, String> getNativePlaceByIdCards(Set<String> idCardSet);

    List<AreaModel> getAreaListByParentId(Long parentId,Boolean isCity,Boolean isCountry);
}
