package cn.smarthse.modules.datacentre.provider.sms;

/**
 *
 * 《短信服务接口定义》
 * <li>由平台2.0.70以上版本的Service提供发送服务
 *
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author yanao
 * @since 2019年11月01日-上午9:15:26
 */
public interface ISMSProviderDaHanService {

	/**
	 *
	 *
	 * @Comments:  <发送短信验证码>
	 * @author yanao
	 * @since 2019年11月01日-上午9:18:27
	 * @param vcode			短信验证码
	 * @param mobile		接收手机号码
	 * @param subcode 短信签名对应子码(大汉三通提供)+自定义扩展子码(选填)，必须是数字，选填，未填使用签名对应子码，通常建议不填
	 * @return
	 */
	String sendVcode(String vcode, String mobile,String subcode);
	
	/**
	 *
	 * 
	 * @Comments:  <通用接口发文本短信>
	 * @author yanao
	 * @since 2019年11月01日-上午9:27:10
	 * @param text			文本内容
	 * @param mobile		手机号码（多个，按逗号隔开）
	 * @param subcode 短信签名对应子码(大汉三通提供)+自定义扩展子码(选填)，必须是数字，选填，未填使用签名对应子码，通常建议不填
	 * @return 1成功
	 */
	String sendTextSms(String text, String mobile,String subcode);
	
}
