package cn.smarthse.modules.datacentre.provider.log;

import cn.smarthse.modules.datacentre.model.log.SysOperLog;
import cn.smarthse.modules.datacentre.model.log.SysOperLogListParam;
import cn.smarthse.modules.datacentre.model.log.SysOperLogListVo;
import com.github.pagehelper.PageInfo;

/**
 * 密码变更操作日志 服务层
 *
 * @author ShenZQ
 * @since 2022/9/16 13:21
 */
public interface ISysOperLogProviderService {

    /**
     * 新增操作日志
     *
     * @param operLog 操作日志对象
     */
    void insertOperlog(SysOperLog operLog);

    PageInfo<SysOperLogListVo> selectOperLogList(SysOperLogListParam param);

    /**
     * 该密码是否可用
     *
     * @param password
     * @param userName
     * @return {@link Boolean}
     * @author ShenZQ
     * @since 2023/7/17 17:30
     */
    Boolean isPasswordAvailable(String password, String userName);

}
