/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2019
 */


package cn.smarthse.modules.datacentre.provider.apps.wm;






import cn.smarthse.modules.datacentre.model.apps.WmAdminModel;
import cn.smarthse.modules.datacentre.model.apps.WmModel;
import cn.smarthse.modules.datacentre.model.entity.wm.WmRecommend;
import cn.smarthse.modules.datacentre.model.entity.wm.WmRecommendpic;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;


/**
* @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
* @Comments:  <对此类的描述，可以引用系统设计中的描述>
* @JDK version used:      <JDK1.8>
* @since 2019-01-07 01:38
*/
public interface IWmRecommendpicService {

   /**
    *
   * @Function: IWmRecommendpicService.java
   * @Description: 该函数的功能描述
   *
   * @param:recommendIds WMRecommend表id串
   * @return：返回结果描述
   * @throws：异常描述
   *
   * @version: v1.0.0
   * @author: cjy
   * @date: 2019年1月9日 上午11:35:54
   *
   * Modification History:
   * Date         Author          Version            Description
   *---------------------------------------------------------*
   * 2019年1月9日      cjy           v1.0.0               修改原因
    */
   List<WmRecommendpic> getListByRecommendId(String recommendIds);
   List<WmRecommendpic> getAllList();


   /**
    *
   * @Function: IWmRecommendpicService.java
   * @Description: 运营后台警示标识列表
   *
   * @param:描述1描述
   * @return：返回结果描述
   * @throws：异常描述
   *
   * @version: v1.0.0
   * @author: cjy
   * @date: 2019年1月17日 下午2:31:02
   *
   * Modification History:
   * Date         Author          Version            Description
   *---------------------------------------------------------*
   * 2019年1月17日      cjy           v1.0.0               修改原因
    */
   List<WmAdminModel> getAdminPicListByMap(Map<String,Object> map);

   /**
    *
   * @Function: IWmRecommendpicService.java
   * @Description: 单表查询 按单个警示标识提示查表(equals)
   *
   * @param:描述1描述
   * @return：返回结果描述
   * @throws：异常描述
   *
   * @version: v1.0.0
   * @author: cjy
   * @date: 2019年1月28日 上午11:23:34
   *
   * Modification History:
   * Date         Author          Version            Description
   *---------------------------------------------------------*
   * 2019年1月28日      cjy           v1.0.0               修改原因
    */
   List<WmRecommendpic> getByName(String name);

   /**
    *
   * @Function: IWmRecommendpicService.java
   * @Description: 单表查询 按单个警示标识提示得到图片全路径(equals)
   *
   * @param:描述1描述
   * @return：返回结果描述
   * @throws：异常描述
   *
   * @version: v1.0.0
   * @author: cjy
   * @date: 2019年1月22日 下午4:30:52
   *
   * Modification History:
   * Date         Author          Version            Description
   *---------------------------------------------------------*
   * 2019年1月22日      cjy           v1.0.0               修改原因
    */
   String getImgPathByName(String name);


   /**
    * 缓存查询 按单个警示标识提示得到图片全路径(equals)
    *
    * @param name 名字
    * @return {@code String }
    * @author zhangxu
    * @date 2023-05-15
    */
   String getImgPathByNameFromCache(String name);

   void add(WmRecommendpic wmRecommendpic, Long adminId);

   /**
    *
    * @Function: IWmByPlatformService.java
    * @Description: 根据危害因素查警示标识
    *
    * @param:描述1描述
    * @return：返回结果描述
    * @throws：异常描述
    *
    * @version: v1.0.0
    * @author: cjy
    * @date: 2019年1月9日 上午10:31:16
    *
    * Modification History:
    * Date         Author          Version            Description
    *---------------------------------------------------------*
    * 2019年1月9日      cjy           v1.0.0               修改原因
    */
   WmRecommend getByHazardId(Long id);

   /**
    * 根据危害因素查警示标识(批量)
    * @Function: IWmByPlatformService.java
    * @Description: 该函数的功能描述
    *
    * @param:描述1描述
    * @return：返回结果描述
    * @throws：异常描述
    *
    * @version: v1.0.0
    * @author: cjy
    * @date: 2019年1月9日 上午10:33:28
    *
    * Modification History:
    * Date         Author          Version            Description
    *---------------------------------------------------------*
    * 2019年1月9日      cjy           v1.0.0               修改原因
    */
   WmModel getByHazardIds(String ids);

   /**
    * 获取所有的警示标识，推荐的靠前
    *
    * @param ids id
    * @return {@code List<WmRecommendpic> }
    * @author zhangxu
    * @date 2023-05-26
    */
   List<WmRecommendpic> getPicsListByHazardIds(String ids);
}
