/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2019
 */


package cn.smarthse.modules.datacentre.provider.apps.occupational;

import cn.smarthse.modules.datacentre.enums.apps.ProtectClassifyEnum;
import cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors;
import cn.smarthse.modules.datacentre.model.apps.protective.HighTempModel;
import cn.smarthse.modules.datacentre.model.apps.protective.LaserModel;
import cn.smarthse.modules.datacentre.model.apps.protective.NoiseModel;
import cn.smarthse.modules.datacentre.model.entity.limit.*;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmSeachModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoModel;
import cn.smarthse.modules.datacentre.model.system.riskFactors.HarmInfoSeachModel;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
*
*
*
*
* @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
* @Comments:  <对此类的描述，可以引用系统设计中的描述>
* @JDK version used:      <JDK1.8>
* @since 2019-01-03 09:58
*/
public interface IOccupationalRiskFactorsService{

   /**
    * 分页查询危害因素限值
    * @param seach
    * @return
    */
   PageInfo<HarmModel> getHazardListByHXFC(HarmSeachModel seach);

   /**
    * 根据类型查询危害因素列表
    * @param type HaezrdTypeEnum
    * @return
    */
   List<HarmModel> getListByType(String type);

   /**
    * 根据首字母查询列表
    * @param initials 首字母(大写)
    * @return
    */
   List<HarmModel> getListByInitials(String initials, String type, String keyword);


   /**
    * 根据id查询model
    * @param id
    * @return
    */
   HarmModel getModelById(Long id);


   /**
    * 查询危害因数
    * @param model
    * @return
    */
   HarmInfoModel getHarmInfoById(HarmInfoSeachModel model);

   /**
    * 查询GBZ2.1的危害因素
    * @return
    */
   List<HarmModel> getListByGBZ(String type, String keyword);


   /*************************/

   /**
    * 	工频电磁场
    * @return
    */
   List<LimitFreqPowerField> getFreqPowerField();

   /**
    * 高频电磁场
    * @return
    */
   List<LimitHighFreq> getHighFreq();

   /**
    * 高温
    * @return
    */
   HighTempModel getHighTemp();

   /**
    * 激光
    * @return
    */
   LaserModel getLaser();

   /**
    * 微波
    * @return
    */
   List<LimitLitteWave> getLitteWave();

   /**
    * 噪声
    * @return
    */
   NoiseModel getNoise();

   /**
    * 超高频电磁场
    * @return
    */
   List<LimitSuperHighFreq> getSuperHighFreq();

   /**
    * 紫外线
    * @return
    */
   List<LimitUltravioletRay> getUltravioletRay();

   /**
    * 振动
    * @return
    */
   List<LimitVibration> getVibration();

   /**
    * 井下作业
    * @return
    */
   List<LimitWorkInPit> getWorkInPit();

   /*************************/

   /**
    *
   * @Function: IOccupationalRiskFactorsService.java
   * @Description: 按照危害因素名称查询表记录
   *
   * @param:描述1描述
   * @return：若存在返回危害因素ID
   * @throws：异常描述
   *
   * @version: v1.0.0
   * @author: cjy
   * @date: 2019年1月28日 上午10:30:03
   *
   * Modification History:
   * Date         Author          Version            Description
   *---------------------------------------------------------*
   * 2019年1月28日      cjy           v1.0.0               修改原因
    */
   OccupationalRiskFactors getByBlendName(String name);

   OccupationalRiskFactors add(OccupationalRiskFactors factor, Long adminId);
}
