package cn.smarthse.modules.datacentre.provider;

import cn.hutool.core.lang.Pair;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.CompanyLoginModel;
import cn.smarthse.modules.datacentre.model.CompanyRefUpdateVo;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyAndOutpackModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseResultModel;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ICompanyProvideBySuperviseService
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 53
 * @since 2019/6/12-14:53
 */
public interface ICompanyProvideBySuperviseService {

    /**
     * 根据SystemDeploymentSourceEnum来获取全部可选企业
     */
    PageInfo<CompanySuperviseModel> getAllOptionalEnterprisesBySystemDeploymentSourceEnum(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize, Boolean count);

    public PageInfo<CompanyAndOutpackModel> pageCompanyAndOutpack(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize);

    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo, Boolean isOwnLevel);

    public CompanySuperviseModel getCompanyInfoById(Long id);

    @Deprecated
    CompanySuperviseModel saveImportCompany(CompanySuperviseModel company, Long loginStaffId);

    /**
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByNameExcludeDelete
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByNameExcludeDelete
     */
    @Deprecated
    public CompanySuperviseModel getByCompanyName(String name, Integer companyType);

    /**
     * 监管用人单位新增方法
     *
     * @param company
     * @param state
     * @param loginStaffId
     * @return Map<String, Object>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/11/17-19:48
     */
    @Deprecated
    Map<String, Object> addCompany(CompanySuperviseModel company, Integer state, Long loginStaffId);

    /**
     * todo 拷贝方法addCompany()。暂不重写，前端没时间对接
     */
    @Deprecated
    Map<String, Object> addCompanyForTraining(CompanySuperviseModel company, Integer state, Long loginStaffId);

    /**
     * 直接添加企业数据，使用saveCompanyAndCompanySuperviseByOne或saveCompanyAndCompanySuperviseByList
     *
     * @param company
     * @param loginStaffId
     * @return cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2021/5/10-16:47
     */
    @Deprecated
    public CompanySuperviseModel addCompanyInfo(CompanySuperviseModel company, Long loginStaffId);

    @Deprecated
    public CompanySuperviseModel updateCompanyBaseInfo(CompanySuperviseModel c, Long loginStaffId);

    /**
     * 只更新传输对象中不为空的字段数据
     *
     * @param companySuperviseModel
     * @param loginStaffId
     * @return void
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2020/12/25-16:47
     */
    @Deprecated
    void updateCompanyOldIsNullField(CompanySuperviseModel companySuperviseModel, Long loginStaffId);

    /**
     * 企业删除（这种企业后续添加，要作为全新企业添加）
     *
     * @param ids
     * @return int
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/26-16:52
     */
    public int delCompanyByIds(String ids);

    /**
     * 企业删除（这种企业后续添加，要作为全新企业添加）
     *
     * @param ids
     * @return int
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/26-16:52
     */
    public int delCompanyByIds(String ids, Integer delReasonItem, String delReason);

    /**
     * 设置示范企业
     *
     * @param ids
     * @return int
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/7/25-11:00
     */
    public int bestCompanyByIds(String ids, Long loginUser);

    /**
     * 取消示范企业
     *
     * @param cid
     * @return int
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/7/25-11:00
     */
    public int cancelBestCompany(Long cid, Long loginUser);

    /**
     * 营业状态变更
     */
    public int businessStateByIds(String ids, Byte flag, Long loginUser);

    public List<CompanyAndOutpackModel> listCompanyAndOutpack(CompanySuperviseSearchModel searchVo);

    /**
     * 通过python脚本更新企业信息
     *
     * @param codes 企业信用代码
     */
    void updateComMsgByPythonScript(List<String> codes);

    /**
     * 通过python脚本 查询企业信息
     *
     * @param code 信用代码
     * @return
     */
    CompanySuperviseModel getComMsgByPythonScript(String code);

    public CompanySuperviseModel getByCompanyNameOrUnifiedSocialCode(String name, String unifiedSocialCode, Integer companyType);

    /**
     * 根据企业名称、信用代码、企业类型 获取企业信息（多个条件and 关系）
     */
    public CompanySuperviseModel getModelByNameOrSocialCode(String name, String unifiedSocialCode, Integer companyType);

    /**
     * 获取市属企业数量
     */
    int countBelongCityCompanyNum(Long areaId);

    /**
     * 存草稿和提交都保存工作场所地址
     */
    void updateAreaIdBycid(Long cid, Long locationAddAreaId, Long updateBy);

    /**
     * 直接批量设置监督单位
     */
    Integer updateCompanySuperviseUnit(Long organizationId, Long organizationAreaId, List<Long> companyIdList);

    /**
     * 获取所有被纳入分类过的企业id
     */
    List<Long> getAllDecCompanyIds();

    /**
     * 根据cid 更新victims_identify字段
     */
    void updateVictimsIdentifyIds(List<Long> cidList, Integer victimsIdentify);

    @Deprecated
    int batchUpdateCompanyRef(List<CompanyRefUpdateVo> updateVoList);

    @Deprecated
    List<CompanySuperviseModel> allCompanyId(CompanySuperviseSearchModel searchVo);

    @Deprecated
    List<CompanySuperviseModel> allCompanyIdName(CompanySuperviseSearchModel searchVo);

    @Deprecated
    List<CompanySuperviseModel> selectIdName(CompanySuperviseSearchModel searchVo);

    @Deprecated
    List<CompanySuperviseModel> listInvalidCid();

    /**
     * 根据cid 修改企业备注
     */
    void updateRemark(CompanySuperviseSearchModel searchVo, Long loginStaffId, Integer remarkLevel);

    /**
     * 根据cid 修改是否存在放射性危害因素
     */
    void updateComsIsExistRadioactivity(List<Long> cidList, Boolean isExistRadioactivity, Long userId);

    /**
     * 根据区域id，获取该区域下有多少企业
     */
    Long getCompanyNumsByAreaId(Long areaId);

    // ================================

    /**
     * 根据cid 获取company表信息
     */
    List<CompanySuperviseModel> getOnlyCompanyByCid(List<Long> cidList);

    /**
     * 根据cid 获取company表信息
     */
    Map<Long, CompanySuperviseModel> getOnlyCompanyMapByCid(List<Long> cidList);

    /**
     * 根据名称 获取company表信息
     */
    List<CompanySuperviseModel> getOnlyCompanyByName(List<String> nameList);

    /**
     * 根据名称 获取company表信息
     */
    Map<String, CompanySuperviseModel> getOnlyCompanyMapByName(List<String> nameList);

    /**
     * 根据信用代码 获取company表信息
     */
    List<CompanySuperviseModel> getOnlyCompanyByUnitCode(List<String> codeList);

    /**
     * 根据信用代码 获取company表信息
     */
    Map<String, List<CompanySuperviseModel>> getOnlyCompanyMapByUnitCode(List<String> codeList);

    /**
     * 根据dataSourceId和dataSource 获取company表信息————排除已删除
     */
    List<CompanySuperviseModel> getOnlyCompanyByDataSourceIdExcludeDelete(List<String> dataSourceIdList, Integer dataSource);

    /**
     * 根据dataSourceDyId 获取company表信息————排除已删除
     */
    List<CompanySuperviseModel> getOnlyCompanyByDataSourceDyIdExcludeDelete(List<String> dataSourceDyIdList);

    // ================================

    /**
     * 根据cid 获取CompanySupervise表信息————排除已删除
     */
    List<CompanySuperviseModel> getOnlyCompanySuperviseByCidExcludeDelete(List<Long> cidList);

    /**
     * 根据cid 获取CompanySupervise表信息————排除已删除
     */
    Map<Long, CompanySuperviseModel> getOnlyCompanySuperviseMapByCidExcludeDelete(List<Long> cidList);

    // ================================

    /**
     * 根据cid 获取company和CompanySupervise表信息
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseByCid(List<Long> cidList);

    /**
     * 根据cid 获取company和CompanySupervise表信息
     */
    Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByCid(List<Long> cidList);

    /**
     * 根据cid 获取company和CompanySupervise表信息————排除已删除
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseByCidExcludeDelete(List<Long> cidList);

    /**
     * 根据cid 获取company和CompanySupervise表信息————排除已删除
     */
    Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseByCidMapExcludeDelete(List<Long> cidList);

    /**
     * 根据名称 获取company和CompanySupervise表信息————排除已删除
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseByNameExcludeDelete(List<String> nameList);
    /**
     * 根据名称 获取company和CompanySupervise和CompanyDy表信息————排除已删除
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseAndCompanyDyByNameExcludeDelete(List<String> nameList);

    /**
     * 根据名称 获取company和CompanySupervise表信息————排除已删除
     */
    Map<String, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByNameExcludeDelete(List<String> nameList);

    /**
     * 根据信用代码 获取company和CompanySupervise表信息
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseByUnitCode(List<String> codeList);

    /**
     * 根据信用代码 获取company和CompanySupervise表信息
     */
    Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCode(List<String> codeList);

    /**
     * 根据信用代码 获取company和CompanySupervise表信息————排除已删除
     */
    List<CompanySuperviseModel> getCompanyAndCompanySuperviseByUnitCodeExcludeDelete(List<String> codeList);

    /**
     * 根据信用代码 获取company和CompanySupervise表信息————排除已删除
     */
    Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(List<String> codeList);

    // ================================

    /**
     * 更新企业-v3 [这里不许再做任何详细校验]
     */
    void updateCompanyAndCompanySuperviseByOne(CompanySuperviseModel c, Long loginStaffId);

    /**
     * 更新企业-v3 [这里不许再做任何详细校验]
     */
    void updateCompanyAndCompanySuperviseByList(List<CompanySuperviseModel> list, Long loginStaffId);

    /**
     * 更新企业-v3 [这里不许再做任何详细校验]
     */
    void updateCompanyByIdList(List<CompanySuperviseModel> list, Long loginStaffId);

    /**
     * 更新企业-v3 [这里不许再做任何详细校验]
     */
    void updateCompanySuperviseByCidList(List<CompanySuperviseModel> list, Long loginStaffId);

    /**
     * 添加企业-v3 [这里不许再做任何详细校验]
     */
    void saveCompanyAndCompanySuperviseByOne(CompanySuperviseModel c, Long loginStaffId);

    /**
     * 添加企业-v3 [这里不许再做任何详细校验]
     */
    void saveCompanyAndCompanySuperviseByList(List<CompanySuperviseModel> list, Long loginStaffId);

    /**
     * 导入回滚
     */
    void rollbackImportCompanyAndCompanySuperviseData(List<Long> idList);

    /**
     * 判断企业名称是否已存在
     */
    Boolean isHaveThisName(String name, Long excludeId, Boolean isValid);

    /**
     * 判断统一社会信用代码是否已存在
     */
    Boolean isHaveThisCreditCode(String creditCode, Long excludeId, Boolean isValid);

    /**
     * 根据统一社会信用代码查询 For登录
     */
    List<CompanyLoginModel> getLoginModelByUnifiedSocialCc(String unifiedSocialCc);

    /**
     * 根据统一社会信用代码查询
     *
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCodeExcludeDelete
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete
     */
    @Deprecated
    List<CompanyListModel> getByUnifiedSocialCc(List<String> unifiedSocialCodes);


    /**
     * 批量新增企业（包含company_supervise 数据）
     * @param companyList
     * @param loginStaffId
     */
    public ImportCompanySuperviseResultModel batchAddCompany(List<CompanySuperviseModel> companyList, Boolean hasErrorAbort);



    public CompanySuperviseModel updateCompanyOnlyBaseInfo(CompanySuperviseModel c, Long loginStaffId);


    public List<String> getAllImportBatchNo();
}
