package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;

import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: ICompanyProvideByHSEService
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 57
 * @since 2019/6/12-14:57
 */
public interface ICompanyProvideByHSEService {

    /**
     * 根据ID获取 企业基本信息
     *
     * @param id
     * @return Company
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/12-15:29
     */
    public CompanyBaseInfoModel getCompanyById(Long id);

    /**
     * 根据企业id 获取企业名称
     *
     * @param id
     * @return java.lang.String
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/9/2-14:42
     */
    public String getCompanyNameById(Long id);

    /**
     * 职业健康系统  企业信息保存
     *
     * @param companyModel
     * @param loginStaffId
     * @param cid
     * @return cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/12-16:24
     */
    public CompanyBaseInfoModel saveOrUpdateCompany(CompanyBaseInfoModel companyModel, Long loginStaffId, Long cid) throws Exception;

    /**
     * 更新  职业病危害风险分类
     *
     * @param cid
     * @param occType
     * @return
     */
    public int updateOccType(Long cid, Integer occType);

    public int batchUpdateOccType(List<CompanySuperviseModel> superviseModelList);

    public int batchUpdatePickupCount(List<CompanySuperviseModel> superviseModelList);

    public int batchUpdateSupervise(List<Long> cidSet);

    /**
     * 监管统计 数据接口
     *
     * @param
     * @return java.util.List<cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2019/6/28-9:10
     */
    @Deprecated
    public List<CompanySuperviseModel> listSuperviseCompanyData();

    @Deprecated
    public Integer countSuperviseCompanyData();

    @Deprecated
    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize);

    public CompanyBaseInfoModel getByName(String name);

    void updateIndustryCategory(Long indusId, Long cid);

    /**
     * 自查报告编辑保存时调用该接口， 更新企业基础信息（数据中心企业表相关字段）
     *
     * @param company
     * @param loginStaffId
     * @return void
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2022/3/24-15:20
     */
    public void updateCompanyBaseInfoModel(CompanyBaseInfoModel company, Long loginStaffId);

    /**
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCodeExcludeDelete
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete
     */
    @Deprecated
    public List<CompanySuperviseModel> getNameCodeByCodes(List<String> codes);

    /**
     * 根据企业信用代码获取企业id
     *
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCode
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseByUnitCodeExcludeDelete
     * @see cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService#getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete
     */
    @Deprecated
    public Long getCidByCode(String code);

}
