package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.*;
import cn.smarthse.modules.datacentre.model.statistics.CompanyChangeStatisticsSearchParam;
import cn.smarthse.modules.datacentre.model.statistics.CompanyChangeStatisticsVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

public interface ICompanyBaseChangeInfoProviderService {

    void addChangeInfo(CompanyBaseChangeInfoAddParam param);

    void batchAddChangeInfo(List<CompanyBaseChangeInfoAddParam> list);

    /**
     * 企业区域变更列表
     *
     * @ Author XiaoYi
     * @ Date  2022/6/22  16:34
     * @ param
     * @ return
     **/
    PageInfo<CompanyAreaChangeInfoModel> getAreaChangeInfoPage(CompanyAreaChangeSearchModel vo);

    /**
     * 企业营业状态变更列表
     *
     * @param changeInfo
     * @return Author zhangxu
     */
    PageInfo<CompanyBusinessStateChangeInfoModel> getBusinessStateChangeInfoPage(CompanyBusinessStateChangeSearchModel changeInfo);

    Map<Long, CompanyChangeStatisticsVo> getComChangeStatisticsBussCountMap(CompanyChangeStatisticsSearchParam param);

    Map<Long, CompanyChangeStatisticsVo> getComChangeStatisticsAreaMoveInCountMap(CompanyChangeStatisticsSearchParam param);

    Map<Long, CompanyChangeStatisticsVo> getComChangeStatisticsAreaMoveOutCountMap(CompanyChangeStatisticsSearchParam param);

    Integer getComOutsideChangeStatisticsChangeInfoDetailCount(CompanyChangeStatisticsSearchParam param);

}
