package cn.smarthse.modules.datacentre.model.zlb;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 浙里办用户信息对象（新版）
 *
 * @author ShenZQ
 * @since 2023/8/31 14:20
 */
@Data
@ApiModel(value = "浙里办用户信息对象")
public class ZlbUserInfo implements Serializable {

    private static final long serialVersionUID = 8836142358618416661L;

    private String userId;
    private String innerUserId;
    @ApiModelProperty("用户类型，PERSON个人/LEGAL_PERSON法人")
    private String userType;
    private PersonInfo personInfo;
    private LegalPersonInfo legalPersonInfo;
    private List<OrganizationInfo> organizationInfoList;
}