package cn.smarthse.modules.datacentre.model.zlb;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.persistence.*;
import lombok.Data;

@Table(name = "zlb_legal_person_info")
@Data
    public class LegalPersonInfo implements Serializable {
        private static final long serialVersionUID = -3878704671044474536L;
        @Id
        @Column(name = "corp_id")
        @GeneratedValue(strategy = GenerationType.IDENTITY)
        @ApiModelProperty("法人唯一键")
        private String corpId;

        @ApiModelProperty("法人名称")
        private String name;
        @ApiModelProperty("社会统一信用代码")
        private String unifiedSocialId;
        @ApiModelProperty("法人类型")
        private String orgType;
        @ApiModelProperty("经办人姓名")
        private String attnName;
        @ApiModelProperty("经办人手机号")
        private String attnPhone;
        @ApiModelProperty("经办人证件类型")
        private String attnIdType;
        @ApiModelProperty("经办人证件号码")
        private String attnIdNo;
        @ApiModelProperty("经办人用户等级")
        private String attnUserType;
        @ApiModelProperty("法人代表人姓名")
        private String principal;
        @ApiModelProperty("法人代表人性别")
        private Integer gender;
        @ApiModelProperty("法人代表人民族")
        private Integer nation;
        @ApiModelProperty("法人代表人证件类型")
        private Integer idType;
        @ApiModelProperty("法人代表人外部证件类型")
        private String outerIdType;
        @ApiModelProperty("法人代表人证件号码")
        private String idNo;
        @ApiModelProperty("法人代表唯一键")
        private String principalUserId;
        @ApiModelProperty("额外属性")
        private Object attributes;
    }