package cn.smarthse.modules.datacentre.model.system.riskFactors;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 危害因素-基础数据
 * @Description 
 * @Author liaoly
 * @Date 2020年4月7日 下午1:12:47
 */
public @Data class OccupationalRiskFactorsModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @ApiModelProperty(value="")
	private Long id;
	/**
	 * 
	 */
    @ApiModelProperty(value="自定义危害因素所属企业id")
	private Long cid;
	/**
	 * 
	 */
    @ApiModelProperty(value="类型(粉尘，化学因素，物理因素，生物因素，放射因素，其他因素)")
	private String type;
	/**
	 * 
	 */
    @ApiModelProperty(value="编码")
	private String paramCode;
	/**
	 * 
	 */
    @ApiModelProperty(value="名称")
	private String nameCh;
	/**
	 * 
	 */
    @ApiModelProperty(value="别名")
	private String alias;
	/**
	 * 
	 */
    @ApiModelProperty(value="CASNo")
	private String casno;
	/**
	 * 
	 */
    @ApiModelProperty(value="标记")
	private String remarks;
	/**
	 * 是否高毒物品
	 */
    @ApiModelProperty(value="是否高毒物品")
	private Integer isHt;
	/**
	 * 是否含有呼尘
	 */
    @ApiModelProperty(value="是否含有呼尘")
	private Integer isHasRespirableDust;
	/**
	 * 职业健康检查因素
	 */
    @ApiModelProperty(value="职业健康检查因素")
	private Integer occupationalHealthId;
	/**
	 * 职业禁忌证
	 */
    @ApiModelProperty(value="职业禁忌证")
	private String occupationalContraindication;
	/**
	 * 职业病 
	 */
    @ApiModelProperty(value="职业病 ")
	private String occupationalDisease;
	/**
	 * 可能导致职业禁忌证和职业病的依据
	 */
    @ApiModelProperty(value="可能导致职业禁忌证和职业病的依据")
	private String basisOccupationalHealth;
	/**
	 * 推荐的职业病危害警示标识
	 */
    @ApiModelProperty(value="推荐的职业病危害警示标识")
	private String warningSignsRecommend;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
    @ApiModelProperty(value="是否有效（0-无效，1-有效）")
	private Boolean isValid;
	/**
	 * 创建人
	 */
    @ApiModelProperty(value="创建人")
	private Long createBy;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
	private java.util.Date createDate;
	/**
	 * 更新人
	 */
    @ApiModelProperty(value="更新人")
	private Long updateBy;
	/**
	 * 更新时间
	 */
    @ApiModelProperty(value="更新时间")
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private java.util.Date updateDate;
	/**
	 * 是否来自GBZ2-2019
	 */
    @ApiModelProperty(value="是否来自GBZ2-2019")
	private Integer belongGbz22019;
    /**
	 * GBZ2-2019名称
	 */
    @ApiModelProperty(value="GBZ2-2019名称")
    private String gbz22019Name;
	/**
	 * 三合一名称
	 */
    @ApiModelProperty(value="三合一名称")
	private String blendName;
	/**
	 * 三合一备注
	 */
    @ApiModelProperty(value="三合一备注")
	private String blendRemark;
	/**
	 * 目录名称
	 */
    @ApiModelProperty(value="目录名称")
	private String catalogName;
	/**
	 * 是否属于目录
	 */
    @ApiModelProperty(value="是否属于目录")
	private Integer belongCatalog;
	/**
	 * GBZ2-2007名称
	 */
    @ApiModelProperty(value="GBZ2-2007名称")
	private String gbz22007Name;
	/**
	 * 是否属于GBZ2-2007
	 */
    @ApiModelProperty(value="是否属于GBZ2-2007")
	private Integer belongGbz22007;
	/**
	 * GBZ188-2014
	 */
    @ApiModelProperty(value="GBZ188-2014名称")
	private String gbz1882014;
	/**
	 * 是否属于gbz188-2014
	 */
    @ApiModelProperty(value="是否属于GBZ188-2014")
	private Integer belongGbz188;
	/**
	 * 
	 */
    @ApiModelProperty(value="")
	private Integer pid;
	/**
	 * 是否显示，1显示，0不显示
	 */
    @ApiModelProperty(value="是否显示，1显示，0不显示")
	private Boolean isShow;
    
    @ApiModelProperty(value="全拼")
    private String fullPy;
    
    @ApiModelProperty(value="拼音首字母")
    private String py;

    @ApiModelProperty(value="危害因素来源(1:目录; 2:GBZ2-2007; 3:GBZ188-2014; 4:GBZ2-2019)")
	private Integer resource;
    
    @ApiModelProperty(value="危害因素来源 多个(目录; GBZ2-2007; GBZ188-2014; GBZ2-2019)")
	private String resourceStr;
    
    @ApiModelProperty(value="修改人")
	private String updateByStr;
}
