/**
 * 
 */
package cn.smarthse.modules.datacentre.model.system.riskFactors;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 提供给平台的危害因素数据model
 * @Description 
 * @Author liaoly
 * @Date 2020年4月13日 上午10:23:02
 */
public @Data class HarmInfoModel implements Serializable{
	private static final long serialVersionUID = 7463503357897121859L;
	
	/**
	 * id
	 */
	@ApiModelProperty(value="id")
	private Long harmId;

	@ApiModelProperty(value="idList")
	private List<Long> harmIdList;
	
	/**
	 * 类型(CN)
	 */
	@ApiModelProperty(value="类型(CN)")
	private String type;
	
	/**
	 * 名称
	 */
	@ApiModelProperty(value="名称")
	private String blendName;
	
	/**
	 * paramCode
	 */
	@ApiModelProperty(value="paramCode")
	private String paramCode;
	
	/**
	 * mac
	 */
	@ApiModelProperty(value="mac")
	private Double mac;
	
	/**
	 * twa
	 */
	@ApiModelProperty(value="twa")
	private Double twa;
	
	/**
	 * stel
	 */
	@ApiModelProperty(value="stel")
	private Double stel;
	
	/**
	 * twa(FC总)
	 */
	@ApiModelProperty(value="twa(FC总)")
	private Double twaTotal;
	
	/**
	 * twa(FC呼)
	 */
	@ApiModelProperty(value="twa(FC呼)")
	private Double twaRespirabel;
	
	/**
	 * cstel总 = 输入的stelTotal / twaTotal * 2
	 */
	@ApiModelProperty(value="cstel总", notes="twa(FC总)+twa(FC呼) 都有时显示 2倍")
	private Double stelTotal;
	
	/**
	 * cstel呼= 输入的twaRespirabel / twaRespirabel * 1.4
	 */
	@ApiModelProperty(value="cstel呼", notes="twa(FC总)+twa(FC呼) 都有时显示 1.4倍")
	private Double stelRespirabel;
	
	/**
	 * 危害因数
	 */
	private Double harmNum = 0d;

}
