package cn.smarthse.modules.datacentre.model.system.riskFactors;

import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "occupational_risk_factors")
public class HarmFactor implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
	private Long id;

	private Long cid;

	private String type;


    @Column(name = "CASNo")
    private String casno;

	@Column(name = "paramCode")
	private String paramcode;

	@Column(name = "name_CH")
	private String nameCh;

	@Column(name = "belong_gbz22007")
	private Integer belongGbz22007;

    @Column(name = "belong_gbz22019")
	private Integer belongGbz22019;

    @Column(name = "gbz22019_name")
	private String gbz22019Name;

    @Column(name = "gbz22007_name")
	private String gbz22007Name;


	@Column(name = "belong_gbz188")
	private Integer belongGbz188;
	@Column(name = "blend_name")
	private String blendName;
	@Column(name = "blend_remark")
	private String blendRemark;
	@Column(name = "catalog_name")
	private String catalogName;
	@Column(name = "belong_catalog")
	private Integer belongCatalog;

    @Column(name = "is_show")
    private Boolean isShow;
    /* 
    * @Comments:  <职业病危害因素性质 1:严重 >
    * @author BinXu(徐斌) [784514607@qq.com]
    * @since 下午2:14 2022/3/7
    **/
    @Column(name = "hazard_nature")
    private String hazardNature;
    /*
     * 接触的危害因素
     **/
    @Column(name = "Exposure_hazards")
    private Integer exposureHazards;

    private String remarks;

    public String getHazardNature() {
        return hazardNature;
    }

    public void setHazardNature(String hazardNature) {
        this.hazardNature = hazardNature;
    }

    public String getHazardNatureStr() {
        if (!StringUtils.isEmpty(hazardNature) && hazardNature.equals("1")){
            return "严重";
        }
        return "一般";
    }

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 更新时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 更新人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public String getGbz22019Name() {
        return gbz22019Name;
    }

    public void setGbz22019Name(String gbz22019Name) {
        this.gbz22019Name = gbz22019Name;
    }

    public String getGbz22007Name() {
        return gbz22007Name;
    }

    public void setGbz22007Name(String gbz22007Name) {
        this.gbz22007Name = gbz22007Name;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Boolean getIsShow() {
        return isShow;
    }

    public void setIsShow(Boolean isShow) {
        this.isShow = isShow;
    }

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
	private String searchKey;
	@Transient
    private String customNameCh;
	@Transient
	private String customExistNameCh;
	@Transient
    @Deprecated
	private Boolean excludeShow; //排除显示隐藏 条件
	@Transient
	private String businessType; //排除显示隐藏 条件

    @Transient
    private List<Long> radIds; //排除的放射因素id



    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Transient
    private Integer  level ;

    @Transient
    private Long  pid ;

    @Transient
    private Boolean  isLeaf;

    @Transient
    private Boolean  expanded;

    public Boolean getExpanded() {
        return expanded;
    }

    public void setExpanded(Boolean expanded) {
        this.expanded = expanded;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getCasno() {
        return casno;
    }

    public void setCasno(String casno) {
        this.casno = casno;
    }

    public Boolean getIsValid() {
		return isValid;
	}
    public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getCid() {
		return cid;
	}

	public void setCid(Long cid) {
		this.cid = cid;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getParamcode() {
		return paramcode;
	}

	public void setParamcode(String paramcode) {
		this.paramcode = paramcode;
	}

	public String getNameCh() {
		return nameCh;
	}

	public void setNameCh(String nameCh) {
		this.nameCh = nameCh;
	}

	public Integer getBelongGbz22007() {
		return belongGbz22007;
	}

	public void setBelongGbz22007(Integer belongGbz22007) {
		this.belongGbz22007 = belongGbz22007;
	}

	public Integer getBelongGbz188() {
		return belongGbz188;
	}

	public void setBelongGbz188(Integer belongGbz188) {
		this.belongGbz188 = belongGbz188;
	}

	public String getSearchKey() {
		return searchKey;
	}

	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}

	public String getCustomNameCh() {
		return customNameCh;
	}

	public void setCustomNameCh(String customNameCh) {
		this.customNameCh = customNameCh;
	}

	public String getCustomExistNameCh() {
		return customExistNameCh;
	}

	public void setCustomExistNameCh(String customExistNameCh) {
		this.customExistNameCh = customExistNameCh;
	}

    public Boolean getExcludeShow() {
        return excludeShow;
    }
    @Deprecated
    public void setExcludeShow(Boolean excludeShow) {
        this.excludeShow = excludeShow;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBlendName() {
        return blendName;
    }

    public void setBlendName(String blendName) {
        this.blendName = blendName;
    }

    public String getBlendRemark() {
        return blendRemark;
    }

    public void setBlendRemark(String blendRemark) {
        this.blendRemark = blendRemark;
    }

    public String getCatalogName() {
        return catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public Integer getBelongCatalog() {
        return belongCatalog;
    }

    public void setBelongCatalog(Integer belongCatalog) {
        this.belongCatalog = belongCatalog;
    }

    public Integer getBelongGbz22019() {
        return belongGbz22019;
    }

    public void setBelongGbz22019(Integer belongGbz22019) {
        this.belongGbz22019 = belongGbz22019;
    }

    public Integer getExposureHazards() {
        return exposureHazards;
    }

    public void setExposureHazards(Integer exposureHazards) {
        this.exposureHazards = exposureHazards;
    }

    public List<Long> getRadIds() {
        return radIds;
    }

    public void setRadIds(List<Long> radIds) {
        this.radIds = radIds;
    }
}
