package cn.smarthse.modules.datacentre.model.system;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 系统附件sysFileModel
 *
 * @Description
 * @Author liaoly
 * @Date 2020年3月2日 上午10:14:38
 */
@Accessors(chain = true)
public @Data class SysFileModel implements Serializable {

    private static final long serialVersionUID = -8888716565842062568L;

    /**
     * ID
     */
    @ApiModelProperty(value = "文件id")
    private Long id;

    private String idStr;
    /**
     * ID
     */
    @ApiModelProperty(value = "企业id")
    private Long cid;

    /**
     * OSS路径地址（相对）
     */
    @ApiModelProperty(value = "OSS路径地址（相对）")
    private String ossUrl;
    /**
     * 来源以FileResourceEnum为准
     */
    @ApiModelProperty(value = "来源以FileResourceEnum为准")
    private Integer resource;

    /**
     * 附件名
     */
    @ApiModelProperty(value = "附件名")
    private String fileName;

    /**
     * 附件大小
     */
    @ApiModelProperty(value = "附件大小")
    private String fileSize;

    /**
     * 附件扩展名（可用于图标展示）
     */
    @ApiModelProperty(value = "附件扩展名（可用于图标展示）")
    private String fileExt;

    /**
     * 附件Hash
     */
    @ApiModelProperty(value = "附件Hash")
    private String fileHash;

    /**
     * 上传IP
     */
    @ApiModelProperty(value = "上传IP")
    private String creatorIp;

    /**
     * 附件描述
     */
    @ApiModelProperty(value = "附件描述")
    private String description;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    @ApiModelProperty(value = "OSS路径地址(精确)")
    private String fullOssurl;

    @ApiModelProperty(value = "App使用")
    private String fullPath;

    private String destPath;
    
    @ApiModelProperty(value = "OSS内部生成的文件ID")
    private String uploadId;
    @ApiModelProperty(value = "当前上传片段的索引（从1开始）")
    private Integer chunkIndex;
    @ApiModelProperty(value = "文件总分片数")
    private Integer chunkTotal;

}
