package cn.smarthse.modules.datacentre.model.system;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 四级行业导出model
 * @Description 
 * @Author liaoly
 * @Date 2020年1月2日 上午10:35:08
 */
public @Data class IndustryExportVo implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 编码
	 */
    @ApiModelProperty(value="行业编号")
	private Long id;
	/**
	 * 
	 */
    @ApiModelProperty(value="行业编码")
	private String code;
	/**
	 * 名称
	 */
    @ApiModelProperty(value="行业名称")
	private String name;
	/**
	 * 行业级别从1开始
	 */
    @ApiModelProperty(value="行业级别从1开始")
	private Integer level;
	/**
	 * 是否是叶子节点
	 */
    @ApiModelProperty(value="是否是叶子节点")
	private Integer isLeaf;
	/**
	 * 描述
	 */
    @ApiModelProperty(value="描述")
	private String description;
	/**
	 * 危害程度WHCD+ 严重 -S  较重 -H  一般-C
	 */
    @ApiModelProperty(value="危害程度WHCD+ 严重 -S  较重 -H  一般-C")
	private String harmLevel;
	/**
	 * 行业类型标记（0: 默认, 无实际含义; 1: 重点行业1-冶金; 2-矿山; 3-化工; 4-建材; 5,6,7...可拓展）
	 */
    @ApiModelProperty(value="行业类型标记（0: 默认, 无实际含义; 1: 重点行业1-冶金; 2-矿山; 3-化工; 4-建材; 5,6,7...可拓展）")
	private Integer industryType;
	/**
	 * 最后修改时间
	 */
    @ApiModelProperty(value="最后修改时间")
    @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
	private java.util.Date updateDate;
    
    /**
     * 得到导出excel的列名称
     * <li>注：参数为空,默认返回{"行业名称|name", "代码|code", "描述|description", "更新时间|updateDate"}
     * @param column : 自定义的列编码（以表字段名为准）
     * @return
     */
	public static String[] getHeadArr(String[] column) {
		
		if (column == null || column.length == 0) {
			String[] headArr = 
				{"行业名称|name", "代码|code", "描述|description", "更新时间|updateDate"};
			return headArr;
		}
		
		//自定义导出列
		String[] headArr = new String[column.length];
		for (int i = 0; i < column.length; i++) {
			switch (headArr[i]) {
			case "name":
				headArr[i] = "行业名称|name";
				break;
			case "code":
				headArr[i] = "代码|code";
				break;
			case "level":
				headArr[i] = "行业等级|level";
				break;
			case "description":
				headArr[i] = "描述|description";
				break;
			case "updateDate":
				headArr[i] = "更新时间|updateDate";
				break;
			} //switch
			
		}//for i
		return headArr;
	}
}
