package cn.smarthse.modules.datacentre.model.supervise;

import lombok.Data;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Data
public class CompanySuperviseSearchModel implements Serializable {

    private static final long serialVersionUID = 2729640088947616126L;

    /**
     * 巡查分级CompanyInspectionClassificationEnum(0-无；1-无危害；2-一般；3-较重；4-严重)
     */
    private Integer inspectionClassification;

    /**
     * 系统部署来源SystemDeploymentSourceEnum
     */
    private Byte systemDeploymentSource;

    /**
     * 企业数据来源CompanyDataSourceEnum
     */
    private Integer dataSource;
    /**
     * 虚拟数据来源CompanyDataSourceVirtuallyEnum约定
     */
    private Integer virtuallyDataSource;

    private Long outpackCid;
    /**
     * 企业名称 (模糊)
     */
    private Long id;
    private String name;

    /**
     * 企业类型：1用人单位， 2外包单位
     */
    private Integer companyType;
    /**
     * 是否测试企业（0-否，1-是）
     */
    private Boolean isTest;
    /**
     * 查询参数 要是存在 isWhichCompany 参数且不为空，就根据 isWhichCompany 来查用人单位用户管理列表数据
     * isWhichCompany
     * 1 查询 用人单位
     * 2 查询 劳务派遣单位
     * 3 查询 用人单位 和 用人兼劳务派遣单位
     */
    private Integer isWhichCompany;
    /**
     * 仅本级
     */
    private Integer belongType;
    private Boolean onlyThisLevel;
    /**
     * 企业名称--监管导入时的名称
     */
    private String oldName;
    /**
     * 企业名称（精确查找）
     */
    private String exactName;
    /**
     * 企业名称与 信用代码的搜索
     */
    private String nameCode;
    //无统一社会信用代码
    private Boolean noUnitCode;
    /**
     * 平台对应的名称
     */
    private String platformName;
    /**
     * 行政区划
     */
    private Long areaId;
    /**
     * 分级分类对应的区域
     */
    private Long gradeAreaId;
    private Byte areaLevel;
    private Boolean excludeGrade = false;    //排除grade 表的关联查询（有的地方不需要查询分级分类信息）
    /**
     * 区域级联--(点省份 获取市级数据)
     */
    private Long areaCasc;
    /**
     * 职业卫生分类 1甲类 2 乙类   3丙类
     */
    private Byte grade;
    /**
     * 所属行业
     */
    private Long industryCategory;
    private List<Long> industryCategoryList;
    /**
     * 所属行业代码
     */
    private String industryCategoryCode;
    /**
     * 用于搜索：行业类别或代码
     */
    private String industrySearch;
    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;
    /**
     * 企业规模
     */
    private Long scale;
    /**
     * 职业病危害风险分类(0-严重、1-较重、2-一般)  CompanyOccTypeEnum
     */
    private Long occupationalRiskClassify;
    /**
     * <span>营业状态 1:正常, 2:暂停营业, 0 :关闭</span>
     */
    private Byte businessState;
    /**
     * 营业状态更新时间， business_state=0 表示关闭时间
     */
    private Date businessUpdateTime;
    /**
     * 注册类型
     */
    private Long registerType;
    private List<Long> registerTypeList;
    /**
     * 示范企业
     */
    private Boolean isBest;

    /**
     * 是否分类监督(all:全年是数据，current：当年数据，false:不是分类对象)
     */
    private String isDeclare;

    /**
     * 是否申报企业(0:未申报 1:已申报)
     */
    private Boolean isReport;
    /**
     * 是否粉尘一体化企业   1是， 0否
     */
    private Integer isFcImportanceCompany;
    /**
     * 包含的企业
     */
    private List<Long> includeCds;
    /**
     * 管辖范围内的cid
     */
    private List<Long> jurisdictionCids;
    private Integer selfJudgeLevel;
    private Date evaluateStartTime;
    private Date evaluateEndTime;

    /**
     * 分类依据：0无来源， 1接害三人以下企业 2 分类自查 3 根据行业划分  4 依据容错自纠调整
     */
    private String gradeSource;

    // 统计查询标识： 统计到期未执行
    private boolean collectUnExecute;
    /**
     * 长兴县
     */
    private Boolean isChangxx = false;
    /**
     * 排除忽略的企业
     */
    private List<Long> ignoreCds;

    // 所属组织机构的区域
    private Byte orgAreaLevel;
    private Long orgAreaId;
    /**
     * 数据分类（1：有数据企业， 2：无数据企业， 3：请求加入企业）
     */
    private Byte dataCategory;
    /**
     * 查询有多个  数据分类 的情况
     */
    private List<Byte> dataCategoryList;
    /**
     * 排序   如： update_date desc
     */
    private String orderby;
    /**
     * 即将到期月份间隔
     */
    private Integer month;

    private Date beginTime;

    private Date endTime;
    /**
     * 查询类型（1申报，2检测，2体检，4，培训）
     */
    private Byte searchType;
    /**
     * 是否本级直属企业
     */
    private Boolean isOwnLevel = false;
    /**
     * 统计列表过来的参数:危害因素
     */
    private String harmIds;
    /**
     * 统计列表过来的参数: 重点行业
     */
    private String industrs;
    /**
     * 有检测企业
     */
    private String checkCids;
    /**
     * 只查询这些企业(id, 根据自我评定而来)
     */
    private List<Long> selfJudgeLevelInCids;
    /**
     * 查询全部 与否
     */
    private Boolean superviseIsDel;
    private Boolean superviseIsHide;
    /**
     * 大于指定 恢复时间
     */
    private Date gtRecoverTime;
    /**
     * 是否被删除的标记
     */
    private Boolean isValid;
    /**
     * 不查询这些企业(id, 根据自我评定而来)
     */
    private List<Long> selfJudgeLevelNotInCids;

    private boolean calcNormalBusiness;

    /**
     * 机构端可选择的 单位区域
     */
    private Set<Long> canChoseProvAreaIdSet;
    private Set<Long> canChoseCityAreaIdSet;
    private Set<Long> canChoseAreaAreaIdSet;
    private Set<Long> canChoseStreAreaIdSet;

    /**
     * 账号状态
     * <option value="1">可用账号</option>
     * <option value="2">禁用账号</option>
     * <option value="0">无账号</option>
     */
    private Integer accountState;

    private List<Long> checkCidList;

    /**
     * 是否治理企业
     */
    private Boolean isGovernance;

    private Long exposureRiskLevel;
    private Boolean chooseCompanyInfo;
    //选择存在的危害因素
    private Long hasHazardFactors;
    // 危害因素的类型
    private String types;
    private List<String> typeList;
    private Boolean onlyCurrent = false;    // 仅当前选中的危害因素
    //选择危害因素检测结果类型，1最近一次存在超标，2历次检测存在超标，3不存在超标，4无检测结果
    private String factorResult;
    /**
     * 重点行业：1，2，3，4 分别对应  矿山  冶金 化工  建材
     */
    private String importantTypes;
    private List<String> importantTypeList;
    private Integer unImportantTypes;
    //接害人数  more3-》大于等于3，less3-》小于3
    private String jhrs;
    //用人单位总人数 more大于等于10，less10小于等于10
    private String staffCount;
    //监督单位
    private Long supervisionUnit;
    //是否包含行业分类结果 1-是，0-否
    private Boolean containCategory;

    private Boolean containLess3Result;

    private Boolean isSuperviseObj;
    private Integer companyCreateDate;
    private Integer phcCheckResult;
    private Integer keyFactor;
    private String pickupCount3;
    private Date companyCreateDateStart;
    private Date companyCreateDateEnd;

    /**
     * 是否显示外包企业
     */
    private Boolean showOuterCompany;

    /**
     * 创建者
     */
    private Long createBy;

    //是否存在放射因素
    private Integer isExistRadioactivity;

    /**
     * 后期需要调整
     */
    @Deprecated
    private String gradeTableName = "company_grade_v3";

    /**
     * 监督状态，1当年被监督，2当年未监督， 3 历年被监督；4 从未被监督
     */
    private Integer supState;
    /**
     * 执法状态，1当年被处罚，2当年未处罚， 3 历年被处罚；4 从未被处罚
     */
    private Integer lawState;
    /**
     * 过滤区域不是街道的数据， 1 是街道， 2不为街道
     */
    private Integer areaIsStreet;

    /**
     * '申报'  0, '体检'  1, '检测'  2 , '培训'  3 , '三同时' 4, '个人防护' 5 , '警示标识' 6 , '职业卫生档案' 7
     */
    private String riskType;
    private String Completed;//完整情况：1以化解 2未化解 3无需风险 1,3以化解+无需风险  Completed和type组合一起才能使用
    private Boolean showRisk = false;

    /**
     * /监测结果超标:0/检测结果超标:1/体检结果异常-疑似职业病处置:2/体检结果异常-职业禁忌证者处置:3
     */
    private String riskCompletionType;
    private String riskCompletionCompleted;//完整情况：1已化解 0未化解 riskCompletionCompleted必须和riskCompletionType组合使用
    private String riskCompletionNoCompletedNum;//全部已化解:0/存在未化解:10-一项未化解:1/二项未化解:2/三项未化解:3

    /**
     * 1依据申报/检测数据
     * 2依据监管认定
     * 3依据企业基本信息
     * 4无判定依据
     */
    private String pickUpSource;

    /**
     * 备注1
     */
    private String remark1;

    /**
     * 备注2
     */
    private String remark2;

    /**
     * 备注3
     */
    private String remark3;

    /**
     * 备注4
     */
    private String remark4;

    /**
     * 备注5
     */
    private String remark5;

    /**
     * 备注6
     */
    private String remark6;

    /**
     * 备注7
     */
    private String remark7;

    /**
     * 备注8
     */
    private String remark8;

    /**
     * 备注9
     */
    private String remark9;

    /**
     * 备注10
     */
    private String remark10;

    /**
     * 显示的备注列（目前仅鹿城区显示，区县级管理员可编辑1-5，区县级普通用户6-7，乡镇管理员8-9，乡镇普通用户10；）
     */
    private String remarkColumns;

    private Integer noCompletedNum;

    /*
     * 是否安装监测/监控设备筛选项，传值说明：
     *      未传companyJcJkInfo字段，或传null/""，或传非下面列出的值 -> 查所有企业（监测监控有其一 或都有 或都没有的企业全查，不影响原有逻辑）
     *      否（无监测监控设备）
     *          NONE -> 查：不存在监测设备 且 不存在监控设备的企业
     *      是（监测监控有其一或二者都有）
     *          JC_OR_JK -> 查：存在监测设备 或 存在监控设备 或 监测和监控设备二者都存在的企业
     *          JC_AND_JK -> 查：监测和监控设备二者都存在的企业
     *          JC -> 查：仅存在监测设备的企业（不存在监控设备）
     *          JK -> 查：仅存在监控设备的企业（不存在监测设备）
     */
    private String companyJcJkInfo;
    /**
     * 导入批号
     */
    private String importBatchNo;

    /**
     * @see ComplianceInfoStatusEnum
     * 合规企业状态
     */
    private List<Byte> complianceStatus;

    /**
     * @see ComplianceInfoLabelEnum
     * 合规异议状态
     */
    private List<Byte> dissentingState;

    /**
     * 是否有申报数据, 0未申报， 11已申报 有申报数据   12已申报 无申报数据
     */
    private Integer hasDeclareData;

    /**
     * 在统计[全部市/全部区县]的：用人单位负责人培训率，用到了此字段。
     * 2：统计所有市
     * 3：统计所有区县
     */
    private Byte searchLevel;

    /**
     * 完成新建企业管理引导的企业， 1是
     */
    private Integer finishedNewCompanyGuide;

    public void setIgnoreCds(List<Long> ignoreCds) {
        if (ignoreCds != null && !ignoreCds.isEmpty()) {
            this.ignoreCds = ignoreCds;
        }
    }

    public void setIncludeCds(List<Long> includeCds) {
        if (includeCds != null && !includeCds.isEmpty()) {
            this.includeCds = includeCds;
        }
    }

    public void setOrg(Object o) {
        if (o != null) {
            Method getSysArea;
            try {
                getSysArea = this.getMethod(o, "getSysArea");
                if (getSysArea != null) {
                    Object sysArea = getSysArea.invoke(o);
                    if (sysArea != null) {

                        Method getLevel = this.getMethod(sysArea, "getLevel");
                        if (getLevel != null) {
                            Object level = getLevel.invoke(sysArea);
                            if (level != null && level instanceof Byte) {
                                this.setOrgAreaLevel((Byte) level);
                            }
                        }

                        Method getId = this.getMethod(sysArea, "getId");
                        if (getId != null) {
                            Object id = getId.invoke(sysArea);
                            if (id != null && id instanceof Long) {
                                this.setOrgAreaId((Long) id);
                            }
                        }
                    }
                }
            } catch (SecurityException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private Method getMethod(Object entity, String methodStr) {
        Method method = null;
        for (Class<? extends Object> clazz = entity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodStr);
                return method;
            } catch (Exception e) {
            }
        }
        return method;
    }
}
