package cn.smarthse.modules.datacentre.model.supervise;

import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDelReasonEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.util.StringUtils;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanySuperviseModel
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 33
 * @since 2019/8/21-14:33
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CompanySuperviseModel extends CompanyBaseInfoModel implements Serializable {

    private static final long serialVersionUID = 8288317860634944482L;
    private long inx;

    /**
     * 巡查分级CompanyInspectionClassificationEnum(0-无；1-无危害；2-一般；3-较重；4-严重)
     */
    private Integer inspectionClassification;

    /**
     * 是否允许修改
     */
    private Boolean isAllowedUpdate;
    private Long superviseId;
    @ApiModelProperty(value = "用于演示环境可隐藏哪些部分的测试数据")
    private Boolean superviseIsHide;
    @ApiModelProperty(value = "用于演示环境可隐藏哪些部分的测试数据")
    private Boolean superviseIsDel;
    @ApiModelProperty(value = "监管系统删除企业的时间")
    private Date superviseDelTime;
    @ApiModelProperty(value = "恢复时间")
    private Date recoverTime;
    @ApiModelProperty(value = "是否是 示范企业（1是）")
    private Boolean isBest;
    @ApiModelProperty(value = "是否是 重点治理（1是）")
    private Boolean govern;

    private Date governTime;

    @ApiModelProperty(value = "分级分类")
    private Byte grade;
    private String gradeName;
    private Integer gradeByIndu;
    private Integer gradeSource;
    /**
     * 直属企业类型：0非直属， 1省直属，2市属
     */
    private Integer belongType;
    /**
     * 企业的直属类型名称
     */
    private String belongTypeName;
    /**
     * 企业最新一次自我评定 结果 1:A级 2:B级 3:C级
     */
    private Integer selfJudgeLevel;
    private String selfJudgeLevelName;

    private String selfStaffName;
    private String selfStaffPhoneNumber;

    @ApiModelProperty(value = "示范企业设置时间")
    private Date bestUpdateTime;
    @ApiModelProperty(value = "自我评定结果")
    private String judge;
    @ApiModelProperty(value = "删除原因")
    private String delReason;
    @ApiModelProperty(value = "删除原因选项")
    private Integer delReasonItem;
    @ApiModelProperty(value = "经营状态：存续，吊销")
    private String operationStatus;
    @ApiModelProperty(value = "申报系统名称")
    private String reportCompanyName;
    @ApiModelProperty(value = "申报日期")
    private Date reportDate;
    @ApiModelProperty(value = "申报类型")
    private String reportType;


    /**
     * 申报是否已完成：1是0否
     */
    @Column(name = "`declare`")
    private Boolean declare;
    private Integer declareNum;
    private Integer declareCount;
    private String declareState;

    /**
     * 体检是否已完成：1是0否
     */
    private Boolean physicalExamination;
    private Integer physicalExaminationNum;
    private String physicalExaminationState;

    /**
     * 检测是否已完成：1是0否
     */
    @Column(name = "`check`")
    private Boolean check;
    private Integer checkNum;
    private String checkRiskState;

    /**
     * 培训是否已完成：1是0否
     */
    private Boolean training;
    private Integer trainingNum;
    private String trainingState;

    /**
     * 三同时是否已完成：1是0否
     */
    private Boolean threeSimultaneous;
    private Integer threeSimultaneousNum;//三同时风险数量
    private Integer threeAllComplete=0;//全部三同时数量
    private Integer threeComplete =0;//未完成三同时数量
    private String threeTimeState;//未完成三同时数量

    /**
     * 个人防护用品是否已完成：1是0否
     */
    private Boolean protectEquip;
    private Integer protectEquipNum;
    private String protectEquipState;

    /**
     * 现场示警标识是否已完成：1是0否
     */
    private Boolean warnSignManage;
    private Integer warnSignManageNum;
    private String warnSignManageState;

    /**
     * 职业卫生档案是否已完成：1是0否
     */
    private Boolean healthManageFiles;
    private Integer healthManageFilesNum;
    private Integer healthComplete;
    private String healthManageState;

    /**
     * 营业状态
     */
    private Byte businessState;
    private String businessStateName;

    /**
     * 工商营业状态
     */
    private Byte irsBusinessState;
    private String irsBusinessStateName;

    /**
     * 营业状态更新时间， business_state=0 表示关闭时间
     */
    private Date businessUpdateTime;
    /**
     * 本单位在册职工总数
     */
    private Integer nameListTotal;
    /**
     * '外委人员总数'
     */
    private Integer externalTotal;
    /**
     * 职业病累计人数
     */
    private Integer occTotal;
    /**
     * '接触粉尘人数'
     */
    private Integer contactDustNum;
    /**
     * 接触化学物质人数
     */
    private Integer contactChemistryNum;
    /**
     * '接触物理因素人数'
     */
    private Integer contactPhysicsNum;
    /**
     * 接触放射性因素人数
     */
    private Integer contactRadiationNum;
    /**
     * 接触生物因素人数
     */
    private Integer contactBiologyNum;
    /**
     * 接触其他因素人数
     */
    private Integer contactOtherNum;
    /**
     * 存在的危害因素、id、危害因素检测结果
     */
    private String hasHazardFactors;
    private String hasHazardFactorsId;
    private String factorResult;
    /**
     * 危害因素类型
     */
    private String typeStr;
    /**
     * 重点行业：1，2，3，4 分别对应  矿山 冶金 化工  建材
     */
    private Integer importantType;

    private String importantTypeName;
    /**
     * 接害人数
     */
    private int jhrs;
    /**
     * 本区域企业数
     */
    private int thisAreaCompanyNum;
    private int thisAreaStopCompanyNum;

    private Integer exposureRiskLevel;
    private String exposureRiskLevelName;
    private Integer checkState;
    private Integer occType;
    private String occTypeName;

    /**
     * 是否完整
     */
    private Boolean keyFactoryComplete;

    /**
     * 存在体检结果
     */
    private Integer phcCheckResult;
    /**
     * 最近一次体检机构
     */
    private String lastPhyOrgName;
    /**
     * 最近一次体检类型
     */
    private String lastPhyType;
    /**
     * 最近一次体检机构时间
     */
    private Date lastPhyOrgDate;
    /**
     * 最近一次检测机构
     */
    private String lastCheckOrgName;
    /**
     * 最近一次体检机构时间
     */
    private Date lastCheckOrgDate;
    private Integer phyType;

    /**
     * 接害人数判断依据
     */
    private Integer pickupCountSource;

    /**
     * 接害人数显示调整
     */
    private String pickupCountAlias;
    /**
     * 接害人数情况
     */
    private Integer isShowVictims;

    /**
     * 添加企业方式（1新增 2导入）拦截器记录操作日志使用此字段
     */
    private Byte insertCompanyType;

    /**
     * 备注1
     */
    private String remark1;

    /**
     * 备注2
     */
    private String remark2;

    /**
     * 备注3
     */
    private String remark3;

    /**
     * 备注4
     */
    private String remark4;

    /**
     * 备注5
     */
    private String remark5;

    /**
     * 备注6
     */
    private String remark6;

    /**
     * 备注7
     */
    private String remark7;

    /**
     * 备注8
     */
    private String remark8;

    /**
     * 备注9
     */
    private String remark9;

    /**
     * 备注10
     */
    private String remark10;

    private Boolean jccb;//检测超标是否已完成
    private Boolean jjz;
    private Boolean yszyb;
    private Boolean jccbzg;

    private Integer jccbNum;//检测超标风险数量
    private Integer jjzNum;
    private Integer yszybNum;

    private Integer jccbNoNum;//检测超标未化解风险数量
    private Integer jjzNoNum;
    private Integer yszybNoNum;

    private String jccbState;//检测超标是否已完成
    private String jjzState;
    private String yszybState;
    private String jccbzgState;

    
    private Integer checkCurCount;//当年检测数据数量（到10.31号）
    private Integer physicalCurCount;//当年体检数据数量（到10.31号）
    

    /**
     * 交办风险，企业是否已被选择（1-已选择，0-未选择）
     */
    private Integer isChoose;

    private Boolean isDecOld;
    private String importBatchNo;

    public void setTingDetailName(String spliter) {
        StringBuffer fullName = new StringBuffer("");
        String provinceName = this.getProvinceName();
        String cityName = this.getCityName();
        String areaName = this.getAreaName();
        String streetName = this.getStreetName();
        if (StringUtils.hasText(provinceName)) {
            fullName.append(provinceName);
        }
        if (StringUtils.hasText(cityName)) {
            fullName.append(spliter);
            fullName.append(cityName);
        }
        if (StringUtils.hasText(areaName)) {
            fullName.append(spliter);
            fullName.append(areaName);
        }
        if (StringUtils.hasText(streetName)) {
            fullName.append(spliter);
            fullName.append(streetName);
        }
        this.setAreaDetailName(fullName.toString());
    }

    public String getDelReason() {
        if (this.delReasonItem != null) {
            String name = CompanyDelReasonEnum.getName(this.delReasonItem);
            if (!StringUtils.isEmpty(delReason)) {
                return name + ":" + delReason;
            } else {
                return name;
            }
        }
        return delReason;
    }

    public String getBelongTypeName() {
        return CompanyBelongTypeEnum.getNameByValue(belongType);
    }

    public String getBusinessStateName() {
        if (businessState != null) {
            return CompanyBusinessState.getName(Integer.valueOf(businessState));
        } else {
            return "";
        }
    }

    public String getIrsBusinessStateName() {
        if (irsBusinessState != null) {
            return CompanyBusinessState.getName(Integer.valueOf(irsBusinessState));
        } else {
            return "";
        }
    }

    public String getGradeSourceName() {
        if (this.getGradeSource() != null) {
            String name = GradeSourceEnum.getName(this.getGradeSource());
            return name;
        }
        return "";
    }
}
