package cn.smarthse.modules.datacentre.model.supervise;

import lombok.Data;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;

public @Data class CompanyBlocSuperviseSearchModel implements  Serializable{/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
     * 企业名称 (模糊)
     */
    private String name;
    /**
     * 企业名称--监管导入时的名称
     */
    private String oldName;
    /**
     * 企业名称（精确查找）
     */
    private String exactName;

	/**
	 * 企业名称与 信用代码的搜索
	 */
	private String nameCode;
    /**
     * 平台对应的名称
     */
    private String platformName;

    /**
     * 行政区划
     */
    private Long areaId;

	/**
	 * 机构ID
	 */
	private Long orgId;
    private String treePath;

	/**
	 * 用于查询使用
	 */
	private String queryTreePath;
    /**
     * 区域级联--(点省份 获取市级数据)
     */
    private Long areaCasc;
    
    
    /**
     * 所属行业
     */
    private Long industryCategory;
	private List<Long> industryCategoryList;

	/**
	 * 所属行业代码
	 */
	private String industryCategoryCode;

    /**
     * 用于搜索：行业类别或代码
     */
    private String industrySearch;
    
    /**
     * 统一社会信用代码 
     */
    private String unifiedSocialCc;
    /**
     * 企业规模
     */
    private Long scale;
    /**
     * 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    private Long occupationalRiskClassify;
	/**
	 * <span>营业状态 1:正常, 2:暂停营业, 0 :关闭</span>
	 */
	private Byte businessState;
    /**
     * 注册类型
     */
    private Long registerType;
    private List<Long> registerTypeList;
	/**
	 * 示范企业
	 */
	private Boolean isBest;

    /**
     * 数据来源，标识监管系统有无数据（1：职业卫生， 2：导入与手动添加）
     * 默认为1
     */
//    private Byte dataSource = 1;

    /**
	 * 包含的企业
	 */
	private List<Long>  includeCds;
	
	/**
	 * 管辖范围内的cid
	 */
	private List<Long>  jurisdictionCids;

	private Date evaluateStartTime;
	private Date evaluateEndTime;
	// 统计查询标识： 统计到期未执行
	private boolean collectUnExecute;

	/**
	 * 长兴县
	 */
	private Boolean isChangxx=false;
	/**
	 * 排除忽略的企业
	 */
	private List<Long>  ignoreCds;
	
//	private Organization org; 
	// 所属组织机构的区域
	private Byte orgAreaLevel;
	private Long orgAreaId;
	/**
     * 数据分类（1：有数据企业， 2：无数据企业， 3：请求加入企业）
     */
    private Byte dataCategory;
    /**
     * 查询有多个  数据分类 的情况
     */
    private List<Byte> dataCategoryList;
    /**
     * 排序   如： update_date desc
     */
    private String orderby;
	/**
	 * 即将到期月份间隔
	 */
	private Integer month;
	
	private Date beginTime;
	
	private Date endTime;
	/**
	 * 查询类型（1申报，2检测，2体检，4，培训）
	 */
	private Byte searchType;
	
	public void setIgnoreCds(List<Long>  ignoreCds) {
		if(ignoreCds!=null &&!ignoreCds.isEmpty()) {
			this.ignoreCds = ignoreCds;
		}
	}
	public void setIncludeCds(List<Long>  includeCds) {
		if(includeCds!=null &&!includeCds.isEmpty()) {
			this.includeCds = includeCds;
		}
	}
	
	public void setOrg(Object o ) {
		if(o!=null) {
			Method getSysArea;
			try {
				getSysArea = this.getMethod(o, "getSysArea");
				if(getSysArea != null) {
					Object sysArea = getSysArea.invoke(o);
					if(sysArea!=null) {
						
						Method getLevel = this.getMethod(sysArea, "getLevel");
						if(getLevel!=null) {
							Object level = getLevel.invoke(sysArea);
							if(level!=null && level instanceof Byte) {
								this.setOrgAreaLevel((Byte)level);
							}
						}
						
						Method getId = this.getMethod(sysArea, "getId");
						if(getId!=null) {
							Object id = getId.invoke(sysArea);
							if(id!=null && id instanceof Long) {
								this.setOrgAreaId((Long)id);
							}
						}
					}
				}
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
			
			
		}
	}
	private Method getMethod(Object entity,String methodStr){
		Method method = null;
		for(Class<? extends Object> clazz = entity.getClass() ; clazz != Object.class ; clazz = clazz.getSuperclass()) {
			try {
				method = clazz.getDeclaredMethod(methodStr) ;
				return method;
			} catch (Exception e) {
			}
		}
		return method;
	}
}
