package cn.smarthse.modules.datacentre.model.supervise;

import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanySuperviseModel
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 33
 * @since 2019/8/21-14:33
 */
public @Data class CompanyBlocSuperviseModel extends CompanyBaseInfoModel implements Serializable {

    /**
     * 用于演示环境可隐藏哪些部分的测试数据
     */
    @ApiModelProperty(value="用于演示环境可隐藏哪些部分的测试数据")
    private Boolean superviseIsHide;
    /**
     *
     */
    @ApiModelProperty(value="用于演示环境可隐藏哪些部分的测试数据")
    private Boolean superviseIsDel;
    /**
     *是否是 示范企业（1是）
     */
    @ApiModelProperty(value="是否是 示范企业（1是）")
    private Boolean isBest;
    /**
     *示范企业设置时间
     */
    @ApiModelProperty(value="示范企业设置时间")
    private Date bestUpdateTime;
    /**
     *自我评定结果
     */
    @ApiModelProperty(value="自我评定结果")
    private String judge;
    /**
     * 经营状态：存续，吊销
     */
    @ApiModelProperty(value="经营状态：存续，吊销")
    private String operationStatus;
    /**
     * 申报系统名称
     */
    @ApiModelProperty(value="申报系统名称")
    private String reportCompanyName;
    /**
     * 申报日期
     */
    @ApiModelProperty(value="申报日期")
    private Date reportDate;
    /**
     * 申报类型
     */
    @ApiModelProperty(value="申报类型")
    private String reportType;



    /**
     * 营业状态
     */
    private Byte businessState;
    /**
     * 本单位在册职工总数
     */
    private Integer nameListTotal;
    /**
     * '外委人员总数'
     */
    private Integer externalTotal;
    /**
     * 职业病累计人数
     */
    private Integer occTotal;
    /**
     * '接触粉尘人数'
     */
    private Integer contactDustNum;
    /**
     * 接触化学物质人数
     */
    private Integer contactChemistryNum;
    /**
     * '接触物理因素人数'
     */
    private Integer contactPhysicsNum;
    /**
     * 接触放射性因素人数
     */
    private Integer contactRadiationNum;
    /**
     * 接触生物因素人数
     */
    private Integer contactBiologyNum;
    /**
     * 接触其他因素人数
     */
    private Integer contactOtherNum;
    /**
     * 存在的危害因素
     */
    private String hasHazardFactors;

    /**
     * 职业卫生管理联系人
     */
    private String occManagerName;
    /**
     * 职业卫生管理联系人电话
     */
    private String occManagerTel;
    /**
     * 接害人数
     */
    private int jhrs;
    /**
     * 职业卫生负责人
     */
    private String directorName;
    /**
     * 负责人手机号码
     */
    private String directorTelephone;

    /**
     * 机构ID
     */
    private Long orgId;

}
