package cn.smarthse.modules.datacentre.model.supervise;

import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName CompanyBaseInfoChangeRecords
 * @Description TODO$
 * @Author 曾华川
 * @Date 2024年02月26日 15:22
 **/
@Data
@Table(name = "company_base_info_change_records")
public class CompanyBaseInfoChangeRecords implements Serializable {

    private static final long serialVersionUID = 4409317306540648823L;

    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 变更前的值
     */
    private String beforeValue;

    /**
     * 变更后的值
     */
    private String afterValue;

    /**
     * 变更类型，见 CompanyBaseChangeType 枚举
     */
    private Integer changeType;
    @Transient
    private String changeName;
    private String reason;

    /**
     * 操作人（账号名称）
     */
    private String operator;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人id
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    public String getChangeName() {
        return CompanyBaseChangeTypeEnum.getName(changeType);
    }
}
