package cn.smarthse.modules.datacentre.model.supervise;

import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeChangeCaseEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 企业营业状态变更记录表
 * </p>
 *
 * @author zhangxu
 * @since 2022-12-26
 */
@Data
@Table(name = "company_base_change_info")
public class CompanyBaseChangeInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 变更前企业状态
     */
    private String beforeValue;//一般是存数字
    private String beforeValue2;
    @Transient
    private String beforeValueText;

    /**
     * 变更后企业状态
     */
    private String afterValue;//一般是存数字
    private String afterValue2;
    @Transient
    private String afterValueText;

    /**
     * 变更类型，见 CompanyBaseChangeTypeEnum 枚举
     */
    private Integer changeType;
    @Transient
    private String changeTypeName;

    /**
     * 变更情况，见 CompanyBaseChangeChangeCaseEnum
     */
    private Integer changeCase;
    @Transient
    private String changeCaseName;

    /**
     * 转入时间
     */
    private Date changeTime;

    /**
     * 转入年份
     */
    private Integer changeYear;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 最后修改人ID
     */
    private Long updateBy;
    /**
     * 操作人（最后修改人）
     */
    @Transient
    private String operators;

    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 企业变更类型
     */
    private Byte title;

    /**
     * 来源id(主表id)
     */
    private Long sourceId;

    @Transient
    private Long nums;
    /**
     * 企业名称
     */
    @Transient
    private String companyName;
    @Transient
    private String unicode;
    @Transient
    private Long detailAreaId;
    @Transient
    private String areaDetailName;

    public String getChangeTypeName() {
        if (Objects.isNull(changeType)) {
            return "";
        }
        return CompanyBaseChangeTypeEnum.getName(changeType);
    }

    public String getChangeCaseName() {
        if (Objects.isNull(changeCase)) {
            return "";
        }
        return CompanyBaseChangeChangeCaseEnum.getName(changeCase);
    }

    public String getBeforeValue() {
        if ("null".equalsIgnoreCase(beforeValue)) {
            return "";
        }
        return beforeValue;
    }

    public String getBeforeValue2() {
        if ("null".equalsIgnoreCase(beforeValue2)) {
            return "";
        }
        return beforeValue2;
    }

    public String getAfterValue() {
        if ("null".equalsIgnoreCase(afterValue)) {
            return "";
        }
        return afterValue;
    }

    public String getAfterValue2() {
        if ("null".equalsIgnoreCase(afterValue2)) {
            return "";
        }
        return afterValue2;
    }
}
