package cn.smarthse.modules.datacentre.model.statistics;

import lombok.Data;

import java.io.Serializable;

/**
 * 用人单位变更统计查询Vo——依据信息变更
 */
@Data
public class CompanyChangeStatisticsWithIdentifyVo implements Serializable {

    private Long areaId;

    private Byte areaLevel;

    private String areaName;

    private Integer normalToPauseNum = 0;                //正常转暂停（变更为暂停企业）

    private Integer normalToCloseNum = 0;                //正常转关闭（删除企业）
    private Integer normalToCloseByTransNum = 0;         //正常转关闭（迁移）

    private Integer pauseToNormalNum = 0;                //暂停转正常（已关闭/暂停营业企业恢复正常）

    private Integer pauseToCloseNum = 0;                 //暂停转关闭（删除企业）
    private Integer pauseToCloseByTransNum = 0;          //暂停转关闭（迁移）

    private Integer closeToNormalNum = 0;                //关闭转正常（已关闭/暂停营业企业恢复正常）

    private Integer victimsNumD3 = 0;                    // 变更为接害人数＜3人

    private Integer victimsNumX3 = 0;                    // 变更为接害人数≥3人

    private Integer laborDispatchNum = 0;                // 变更为劳务派遣单位

    private Integer employersNum = 0;                    // 变更为用工单位

    private Integer laborDispatchAndEmployersNum = 0;    // 变更为兼具劳务派遣单位和用工单位

}
