/**
 * 
 */
package cn.smarthse.modules.datacentre.model.stat;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 《企业基础统计>企业规模 》
 * 
 * 
 * @Project:  smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年6月19日-上午8:38:33
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompayParamStatTreeGridModel extends CompayParamStatModel implements Serializable {
	private static final long serialVersionUID = 3471047016811019273L;
    
	@ApiModelProperty(value="treeGrid属性: Id")
	private Long id;
	
	//节点的级别，默认最高级为0
    @ApiModelProperty(value="treeGrid属性: 层级")
    private Integer level;
    
    //是否为叶节点，为true时表示该节点下面没有子节点了
    @ApiModelProperty(value="treeGrid属性: 是否子叶")
    private Boolean isLeaf;
    
    //是否默认展开状态
    @ApiModelProperty(value="treeGrid属性: 是否展开")
    private Boolean expanded;
    
    @ApiModelProperty(value="treeGrid属性: 是否已经加载过子节点（为false时点击节点会自动加载子节点）")
    private Boolean loaded;
    
    @ApiModelProperty(value="treeGrid属性: 图标")
    private String icon;
    
}
