package cn.smarthse.modules.datacentre.model.platformAdmin.search;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 危害因素搜索-运营后台model
 * @Description 
 * @Author liaoly
 * @Date 2020年4月7日 下午4:14:13
 */
public @Data class RiskFactorSearchModel implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="当前页数")
	private int pageNum = 1;
	
	@ApiModelProperty(value="每页条数")
	private int pageSize = 30;
	
	@ApiModelProperty(value="危害因素id")
	private Long riskFactorId;
	
	@ApiModelProperty(value="模糊匹配关键字")
	private String keyword;
	
	@ApiModelProperty(value="危害因素类型(粉尘，化学因素，物理因素，生物因素，放射因素，其他因素)")
	private String type;
	
	@ApiModelProperty(value="危害因素来源(1:目录; 2:GBZ2-2007; 3:GBZ188-2014; 4:GBZ2-2019)")
	private Integer resource;
	
	@ApiModelProperty(value="是否显示，1/true显示，0/false不显示")
	private Boolean isShow;
}
