/**
 * 
 */
package cn.smarthse.modules.datacentre.model.platform.riskFactors;

import java.io.Serializable;

import javax.persistence.Column;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 《企业软件 用户搜索Model》
 * 
 * 
 * @Project:  platform-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年11月20日-上午9:10:15
 */
public @Data class HarmModel implements Serializable{
	private static final long serialVersionUID = 7463503357897121859L;
	
	@ApiModelProperty(value="id")
	private Long id;
	
	@ApiModelProperty(value="类型(CN)")
	private String type;
	
	@ApiModelProperty(value="名称")
	private String blendName;
	
	@ApiModelProperty(value="备注")
	private String blendRemark;
	
	@ApiModelProperty(value="CASNO")
	private String casno;
	
	@ApiModelProperty(value="全拼")
	private String full_py;
	
	@ApiModelProperty(value="首字母")
	private String py;
	
	@ApiModelProperty(value="是否有详情")
	private Boolean isView;
	
	@ApiModelProperty(value="mac")
	private String mac;

	@ApiModelProperty(value="峰接触浓度(5twa)")
	private String twa5;

	@ApiModelProperty(value="twa")
	private String twa;
	
	@ApiModelProperty(value="stel")
	private String stel;
	
	@ApiModelProperty(value="超限倍数")
	private String maxExcursionLimit;
	
	@ApiModelProperty(value="twa(FC总)")
	private String twaTotal;
	
	@ApiModelProperty(value="twa(FC呼)")
	private String twaRespirabel;
	
	@ApiModelProperty(value="超限倍数(FC)")
	private String maxExcursionLimitFc;

	@ApiModelProperty(value="cstel总", notes="twa(FC总)+twa(FC呼) 都有时显示 2倍")
	private String stelTotal;
	
	@ApiModelProperty(value="cstel呼", notes="twa(FC总)+twa(FC呼) 都有时显示 1.4倍")
	private String stelRespirabel;
	
	
}
