package cn.smarthse.modules.datacentre.model.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SysOperLogListVo implements Serializable {

    /**
     * 密码变更操作日志主键
     */
    private Long operId;

    /**
     * 标题
     */
    private String title;

    /**
     * [约定BusinessTypeEnum枚举]业务类型（0-其它，1-修改密码，2-重置密码）
     */
    private Integer businessType;

    /**
     * 被修改账号所属的企业id、机构id、监管id、运维id
     */
    private Long cid;

    /**
     * （冗余）被修改账号名称
     */
    private String userName;

    /**
     * （冗余）操作账号名称
     */
    private String operName;

    /**
     * 请求方法
     */
    private String method;

    /**
     * 请求方式
     */
    private String requestMethod;

    /**
     * 请求url
     */
    private String operUrl;

    /**
     * 主机地址
     */
    private String operIp;

    /**
     * 操作地点
     */
    private String operLocation;

    /**
     * 请求参数
     */
    private String operParam;

    /**
     * 返回参数
     */
    private String jsonResult;

    /**
     * [约定枚举]操作状态（0-成功，1-失败）
     */
    private Integer status;

    /**
     * 错误消息
     */
    private String errorMsg;

    /**
     * 创建人ID，即操作账号ID
     */
    private Long createBy;

    /**
     * 创建时间，即操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    private String password;

    /**
     * [约定OperatorDataSourceEnum枚举]数据隶属（0-其它，1-企业端，2-监管端，3-运维端，4-机构端）
     */
    private Integer dataOf;

    /**
     * [约定OperatorDataSourceEnum枚举]数据来源（0-其它，1-企业端，2-监管端，3-运维端，4-机构端）
     */
    private Integer dataSource;
}

