package cn.smarthse.modules.datacentre.model.log;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 密码变更操作日志 oper_log
 *
 * @author ShenZQ
 * @since 2022/9/16 13:21
 */
@Table(name = "sys_oper_log")
public @Data class SysOperLog implements Serializable {

    /**
     * 密码变更操作日志主键
     */
    @Id
    @Column(name = "oper_id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long operId;

    /**
     * 标题
     */
    @Column(name = "title")
    private String title;

    /**
     * [约定BusinessTypeEnum枚举]业务类型（0-其它，1-修改密码，2-重置密码）
     */
    @Column(name = "business_type")
    private Integer businessType;

    /**
     * 被修改账号所属的企业id、机构id、监管id、运维id
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * （冗余）被修改账号名称
     */
    @Column(name = "user_name")
    private String userName;

    /**
     * （冗余）操作账号名称
     */
    @Column(name = "oper_name")
    private String operName;

    /**
     * 请求方法
     */
    @Column(name = "method")
    private String method;

    /**
     * 请求方式
     */
    @Column(name = "request_method")
    private String requestMethod;

    /**
     * 请求url
     */
    @Column(name = "oper_url")
    private String operUrl;

    /**
     * 主机地址
     */
    @Column(name = "oper_ip")
    private String operIp;

    /**
     * 操作地点
     */
    @Column(name = "oper_location")
    private String operLocation;

    /**
     * 请求参数
     */
    @Column(name = "oper_param")
    private String operParam;

    /**
     * 返回参数
     */
    @Column(name = "json_result")
    private String jsonResult;

    /**
     * [约定枚举]操作状态（0-成功，1-失败）
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 错误消息
     */
    @Column(name = "error_msg")
    private String errorMsg;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人ID，即操作账号ID
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间，即操作时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private String password;

    /**
     * [约定OperatorDataSourceEnum枚举]数据隶属（0-其它，1-企业端，2-监管端，3-运维端，4-机构端）
     */
    @Column(name = "data_of")
    private Integer dataOf;

    /**
     * [约定OperatorDataSourceEnum枚举]数据来源（0-其它，1-企业端，2-监管端，3-运维端，4-机构端）
     */
    @Column(name = "data_source")
    private Integer dataSource;

}

