package cn.smarthse.modules.datacentre.model.log;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《企业操作日志表》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-6-12-下午4:15:43
 */
@Table(name = "sys_log")
public @Data class SysLog implements Serializable {
	private static final long serialVersionUID = -982613299701783643L;
	
	/**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    
    /**
     * 操作账号(冗余)
     */
    private String username;

    @Transient
    private String companyName;
    /**
     * 用户姓名(冗余)
     */
    private String fullname;

    /**
     * 日志标题
     */
    private String title;

    /**
     * 请求IP地址
     */
    @Column(name = "remote_ip")
    private String remoteIp;

    /**
     * 用户代理信息
     */
    @Column(name = "user_agent")
    private String userAgent;

    /**
     * 请求URI
     */
    @Column(name = "request_uri")
    private String requestUri;

    /**
     * 操作方式、post/get/push等resetful
     */
    @Column(name = "request_method")
    private String requestMethod;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 类型(0-异常日志,1-登录日志,2-操作日志）
     * <li>详细查看LogConstans
     */
    private Byte type;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 操作提交的数据内容(json)或者异常信息
     */
    private String params;

    /**
     * 日志来源（用户类型）(1-用人单位（企业端）,2-专业机构,3-监管）
     */
    @Column(name = "log_source")
    private Byte logSource;


    @Transient
    private Long provinceId;
    @Transient
    private Long cityId;
    @Transient
    private Long areaId;
    @Transient
    private Long streetId;

  
}