package cn.smarthse.modules.datacentre.model.companyoutpack;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyOutpackSearchModel
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 17
 * @since 2020/8/5-16:17
 */
@Data
public class CompanyOutpackSearchModel implements Serializable {

    private String companyName;
    private String unifiedSocialCC;

    private Long areaId;
    private Long industryCategory;
    private List<Long> registerTypeList;
    private List<Long> industryCategoryList;
    private Long registerType;
    private Byte areaLevel;
    private Byte businessState;
    /**
     * 外包单位 信息中的区划
     */
    private Long outAreaId;
    private Byte outAreaLevel;
    /**
     * 可在本辖区提供外包服务的外包单位
     */
    private Boolean searchAll = false;
    private Boolean isTest;

    private String keyword;
    private String includeCds;
    private List<Long> includeCidList;


    /**
     * 大于指定 恢复时间
     */
    private Date gtRecoverTime;

    /**
     * true显示本级 false非本级
     */
    private Boolean onlyThisLevel;
    /**
     * '直属企业类型（0-非直属，1-省直属，2-市属）'
     */
    private Integer belongType;

    /**
     * 开始时间
     */
    private Date beginTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    private Integer isFcImportanceCompany;
}
