package cn.smarthse.modules.datacentre.model.companyoutpack;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@ApiModel(value="企业外包单位基础信息")
@Data
public class CompanyOutpackModel implements Serializable {
    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private Long id;

    /**
     * fullname企业名称
     */
    @ApiModelProperty(value = "fullname企业名称")
    private String name;

    /**
     * corp_cc统一社会信用代码
     */
    @ApiModelProperty(value = "corp_cc统一社会信用代码 ")
    private String unifiedSocialCc;

    /**
     * corp_area_id 行政区域区编号
     */
    @ApiModelProperty(value = "corp_area_id 行政区域区编号")
    private Long areaId;
    /**
     * corp_area_id 行政区域区编号
     */
    @ApiModelProperty(value = "corp_area_id 行政区域区编号")
    private String areaName;

    /**
     * 注册类型-经济分类
     */
    @ApiModelProperty(value = "注册类型-经济分类")
    private Long registerType;
    private String registerTypeName;

    /**
     * 企业注册地详址
     */
    @ApiModelProperty(value = "企业注册地详址")
    private String registerAddress;

    /**
     * 企业通讯地址
     */
    @ApiModelProperty(value = "  企业通讯地址")
    private String companyPostalAdress;

    /**
     * 营业状态,   1正常，2暂停营业，0关闭
     */
    @ApiModelProperty(value = "营业状态,   1正常，2暂停营业，0关闭")
    private Byte businessState;

    /**
     * corp_type 行业分类（sys_param.param_code）
     */
    @ApiModelProperty(value = "corp_type 行业分类（sys_param.param_code）")
    private Long industryCategory;
    private String industryCategoryName;

    /**
     * 法人代表姓名
     */
    @ApiModelProperty(value = "法人代表姓名")
    private String legalName;

    /**
     * 法人代表联系电话
     */
    @ApiModelProperty(value = "法人代表联系电话")
    private String legalTel;

    /**
     * 职业卫生负责人
     */
    @ApiModelProperty(value = "职业卫生负责人")
    private String occLeaderName;

    /**
     * 职业卫生负责人联系电话
     */
    @ApiModelProperty(value = "职业卫生负责人联系电话")
    private String occLeaderTel;

    /**
     * 企业电子邮箱
     */
    @ApiModelProperty(value = "企业电子邮箱")
    private String companyContactEmail;

    /**
     * 企业联系电话
     */
    @ApiModelProperty(value = "企业联系电话")
    private String companyContactTel;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}

