package cn.smarthse.modules.datacentre.model.companyBaseChangeInfo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CompanyBaseChangeInfoAddParam implements Serializable {

    private Long id;
    /**
     * 企业ID
     */
    private Long cid;
    /**
     * 变更前企状态
     */
    private String beforeValue;//一般是存数字
    private String beforeValue2;
    /**
     * 变更后企业状态
     */
    private String afterValue;//一般是存数字
    private String afterValue2;
    /**
     * 变更类型，见 CompanyBaseChangeTypeEnum 枚举
     */
    private Integer changeType;
    /**
     * 转入时间
     */
    private Date changeTime;
    /**
     * 转入年份
     */
    private Integer changeYear;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 最后修改人ID
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createDate;
    /**
     * 最后修改时间
     */
    private Date updateDate;

    public String getBeforeValue() {
        if ("null".equalsIgnoreCase(beforeValue)) {
            return "";
        }
        return beforeValue;
    }

    public String getBeforeValue2() {
        if ("null".equalsIgnoreCase(beforeValue2)) {
            return "";
        }
        return beforeValue2;
    }

    public String getAfterValue() {
        if ("null".equalsIgnoreCase(afterValue)) {
            return "";
        }
        return afterValue;
    }

    public String getAfterValue2() {
        if ("null".equalsIgnoreCase(afterValue2)) {
            return "";
        }
        return afterValue2;
    }
}
