package cn.smarthse.modules.datacentre.model.bloc.organization;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: BlocOrganizationModel
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 47
 * @since 2020/4/3-12:47
 */
public @Data
class BlocOrganizationModel implements Serializable {
    /**
     * ID
     */
    private Long id;

    /**
     * 上级组织id
     */
    private Long pid;

    /**
     * 是否是部门
     */
    private Boolean isDetp;
    /**
     * 是部门的情况下： 该部门所属公司ID
     */
    private Long cid;
    /**
     * 组织名称 、部门
     */
    private String organizationName;

    /**
     * 层级
     */
    private Byte level;

    /**
     * 组织树路径（个祖先节点以逗号分隔）
     */
    private String treePath;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 子节点顺序
     */
    private Integer orderNum;



    /**
     * 是否叶子节点
     */
    private boolean isLeaf=false;

    /**
     * 是否默认展开
     */
    private boolean expanded=false;


    private static final long serialVersionUID = 1L;
}
