package cn.smarthse.modules.datacentre.model.apps.protective;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 
* 
* @ClassName: HearingProtectionModel.java
* @Description: 听力防护model
*
* @version: v1.0.0
* @author: cjy
* @date: 2019年1月14日 上午10:05:43 
*
* Modification History:
* Date         Author          Version            Description
*---------------------------------------------------------*
* 2019年1月14日      cjy          v1.0.0               修改原因
 */
@ApiModel("听力防护model")
public @Data class HearingProtectionModel implements Serializable {

	// @Fields serialVersionUID : TODO
	private static final long serialVersionUID = 7703108535915422339L;
	
	@ApiModelProperty(value="前端传参:噪声强度(必填)")
	private Double noiseStrength;
	
	@ApiModelProperty(value="前端传参:1,70-75;2,75-80(必填)")
	private Integer valType; 
	
	@ApiModelProperty(value="前端传参:保护水平最高值(非必填)")
	private Double highValue; 
	
	@ApiModelProperty(value="前端传参:保护水平最低值(非必填)")
	private Double lowValue; 
	
	@ApiModelProperty(value="后端返回:推荐结果-文字说明")
	private String desc;
	
	private List<ProtectProductModel> products;
	
	@ApiModelProperty(value="后端返回:提示")
	private String notes;

}
