package cn.smarthse.modules.datacentre.model.apps;

import lombok.Data;

import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 
* 
* @ClassName: WmAdminModel.java
* @Description: 运营后台警示标识model
*
* @version: v1.0.0
* @author: cjy
* @date: 2019年1月17日 上午10:29:31 
*
* Modification History:
* Date         Author          Version            Description
*---------------------------------------------------------*
* 2019年1月17日      cjy          v1.0.0               修改原因
 */
public @Data class WmAdminModel implements Serializable {

	// @Fields serialVersionUID : TODO
	private static final long serialVersionUID = -2343354476185704410L;
	
	/**
	 * 危害因素ID
	 */
	 @Transient
	private Long hazardId;
	 
	/**
	 * 推荐警示标识ID
	 */
	 @Transient
	private Long recommendId;
	 
	/**
	 * 危害因素名称
	 */
	 @Transient
	private String hazardName;
	
	 /**
	 * 警示标识唯一标识
	 */
	 @Transient
	private String typeId;
		 
	/**
	 * 警示标语
	 */
	 @Transient
	private String warningLabel;
	
	/**
	 * 警示图片(多个用逗号分隔)
	 */
	@Transient
	private String warningImg;
	
	/**
	 * 上传时间
	 */
	 @Transient
	private Date updateDate; 

}
