package cn.smarthse.modules.datacentre.model.apps;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 
* 
* @ClassName: NoiseCalcuModel.java
* @Description: 噪声计算工具model
*
* @version: v1.0.0
* @author: cjy
* @date: 2018年12月14日 上午11:08:02 
*
* Modification History:
* Date         Author          Version            Description
*---------------------------------------------------------*
* 2018年12月14日      cjy          v1.0.0               修改原因
 */
@ApiModel(value="噪声计算工具model")
public @Data class NoiseCalcuModel implements Serializable {
	
	private static final long serialVersionUID = -8634893468273255246L;
	
//	CacuLaeqtModel[] cacuLaeqt;
	
	@ApiModelProperty(value="作业场所噪声强度")
	String laeqts;
	
	@ApiModelProperty(value="接触场所噪声的时间(小时)")
	String ts;
	
	@ApiModelProperty(hidden=true)
	Double[] laeqt;
	
	@ApiModelProperty(hidden=true)
	Double[] t;
	
	
	@ApiModelProperty(value="每周实际工作时间(天)")
	Double de;
	
	@ApiModelProperty(value="后台返回数据:8小时等效A计权声级")
	Double LEX8h;
	
	@ApiModelProperty(value="后台返回数据:40小时等效A计权声级")
	Double LEX40h;
}
