package cn.smarthse.modules.datacentre.model;

import cn.smarthse.modules.datacentre.enums.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 《数据中心企业基础信息Model》
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: smarthse-facade-common
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2019年5月30日-下午1:32:37
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CompanyBaseInfoModel implements Serializable {
    private static final long serialVersionUID = -798554499553566968L;

    @ApiModelProperty(value = "企业编号, 与 cid同值")
    protected Long id;
    @ApiModelProperty(value = "企业编号")
    protected Long cid;

    private String lng;
    private String lat;

    @ApiModelProperty(value = "省编号")
    protected Long provinceId;
    @ApiModelProperty(value = "省名称")
    protected String provinceName;
    @ApiModelProperty(value = "市编号")
    protected Long cityId;
    @ApiModelProperty(value = "市名称")
    protected String cityName;
    @ApiModelProperty(value = "区域ID")
    protected Long areaId;
    @ApiModelProperty(value = "区域名称")
    protected String areaName;
    @ApiModelProperty(value = "乡镇街道编号")
    protected Long streetId;
    @ApiModelProperty(value = "乡镇街道名称")
    protected String streetName;
    @ApiModelProperty(value = "行政区域详情：原始存放的编号")
    protected Long areaDetailId;
    @ApiModelProperty(value = "行政区域详情：省市区县街道")
    protected String areaDetailName;
    @ApiModelProperty(value = "行政区域 层级")
    protected Byte areaLevel;
    @ApiModelProperty(value = "fullname企业名称")
    protected String name;

    private Integer companyType;
    /**
     * 信用代码状态（0默认， 2信用代码错误）
     */
    private Integer socialCcState;

    /**
     * 是否测试企业（0-否，1-是）
     */
    private Boolean isTest;
    /**
     * 顺序码
     */
    private Integer seq;
    @ApiModelProperty(value = "企业名称简称")
    protected String shortName;
    @ApiModelProperty(value = "上属公司（或主管单位）")
    protected String fatherDept;
    @ApiModelProperty(value = "成立时间")
    protected java.util.Date settingTime;
    @ApiModelProperty(value = "用人单位竣工/投产时间")
    protected java.util.Date productionTime;
    @ApiModelProperty(value = "corp_cc统一社会信用代码（此处该代码用于显示，由平台申请企业认证赋予数据）")
    protected String unifiedSocialCc;
    @ApiModelProperty(value = "corp_tel 企业联系电话	")
    protected String companyContactTel;
    @ApiModelProperty(value = "corp_email 企业电子邮箱	")
    protected String companyContactEmail;
    @ApiModelProperty(value = "企业传真")
    protected String companyContactFax;
    @ApiModelProperty(value = "企业注册地详址行政区划id")
    protected Long registerAddressRegionId;
    @ApiModelProperty(value = "企业注册地详址")
    protected String registerAddress;

    @ApiModelProperty(value = "注册地址省编号")
    protected Long registerProvinceId;
    @ApiModelProperty(value = "注册地址省名称")
    protected String registerProvinceName;
    @ApiModelProperty(value = "注册地址市编号")
    protected Long registerCityId;
    @ApiModelProperty(value = "注册地址市名称")
    protected String registerCityName;
    @ApiModelProperty(value = "注册地址区域ID")
    protected Long registerAreaId;
    @ApiModelProperty(value = "注册地址区域名称")
    protected String registerAreaName;
    @ApiModelProperty(value = "注册地址乡镇街道编号")
    protected Long registerStreetId;
    @ApiModelProperty(value = "注册地址乡镇街道名称")
    protected String registerStreetName;
    @ApiModelProperty(value = "注册地址行政区域详情：原始存放的编号")
    protected Long registerAreaDetailId;
    @ApiModelProperty(value = "注册地址行政区域详情：省市区县街道")
    protected String registerAreaDetailName;
    @ApiModelProperty(value = "注册地址行政区域 层级")
    protected Byte registerAreaLevel;

    @ApiModelProperty(value = "企业注册地址邮编")
    protected String registerPost;
    @ApiModelProperty(value = "companyPostalAdress 企业通讯地址")
    protected String companyPostalAdress;
    @ApiModelProperty(value = "工作产所地址（工作场所地址）")
    protected String workAddress;
    @ApiModelProperty(value = "注册类型")
    protected Long registerType;
    @ApiModelProperty(value = "注册类型名称")
    protected String registerTypeName;
    /**
     * 监督单位
     */
    private Long supervisionUnit;
    /**
     * 监督单位名称
     */
    private String supervisionUnitName;
    /**
     * 监督单位区域
     */
    private Long supervisionAreaId;
    @ApiModelProperty(value = "corp_type 行业分类（sys_param.param_code）id")
    protected Long industryCategory;

    /**
     * 行业来来源， 0普通， 1来自工商局
     */
    private Integer industrySource;
    @ApiModelProperty("行业分类code")
    protected String industryCategoryCode;
    private String industryCode;    // 行业分类编码，搜索条件
    @ApiModelProperty(value = "corp_type 行业分类名称（sys_param.param_code）")
    protected String industryCategoryName;
    @ApiModelProperty(value = "职业病危害风险分类(0-严重、1-较重、2-一般)")
    protected Integer occupationalRiskClassify;
    @ApiModelProperty(value = "在岗职工人数")
    protected Integer staffCount;
    @ApiModelProperty(value = "接害人数（不重复计）")
    protected Integer pickupCount;
    @ApiModelProperty(value = "接害人数统计来源-- PickupCountSourceEnum")
    protected Integer pickupCountSource;
    /**
     * 当年接害人数是否被监管判定(0-否，1-接害人数<3，2-接害人数≥3)
     */
    private Integer victimsIdentify;
    @ApiModelProperty(value = "主营营业收入（万元）")
    protected java.math.BigDecimal mainOperaIncome;
    @ApiModelProperty(value = "注册资本")
    protected java.math.BigDecimal registerCapital;
    @ApiModelProperty(value = "企业规模")
    protected String scale;
    @ApiModelProperty(value = "企业规模(名称）")
    protected String scaleName;
    @ApiModelProperty(value = "企业年度产值")
    protected java.math.BigDecimal yearAssets;
    @ApiModelProperty(value = "企业资产总值")
    protected java.math.BigDecimal totalAssets;
    @ApiModelProperty(value = "法人代表姓名")
    protected String legalName;
    @ApiModelProperty(value = "法人代表联系电话")
    protected String legalTel;
    @ApiModelProperty(value = "化学事故应急咨询服务电话")
    protected String chemicalEmergencyPhone;
    @Deprecated
    @ApiModelProperty(value = "职业卫生负责人")
    protected Long occLeaderSid;
    @Deprecated
    @ApiModelProperty(value = "职业卫生负责人联系电话")
    protected String occLeaderTel;
    /**
     * 职业卫生管理联系人
     */
    private String occManagerName;
    /**
     * 职业卫生管理联系人电话
     */
    private String occManagerTel;
    /**
     * 企业主要负责人
     */
    private String mainLeaderName;
    /**
     * 负责人手机号码
     */
    private String mainLeaderTel;
    @ApiModelProperty(value = "企业logo url 地址")
    protected String logoFileUrl;
    @ApiModelProperty(value = "平台字段）企业编号串扩展(社会统一信代码/登记号/组织代码)")
    protected String corpCcExtend;
    @ApiModelProperty(value = "平台字段）注册/创建时间")
    protected java.util.Date createDate;
    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
    /**
     * 处罚次数
     */
    private Integer punishNum;
    /**
     * 是否有被纳入分类监督企业过(0-否,1-是)
     */
    protected Boolean isDec;
    private String isDecName;
    /**
     * 是否是今年分类监督企业(0-否,1-是)
     */
    protected Boolean isDecCurrentYear;

    private Boolean isDecOld;
    protected String isDecCurrentYearName;
    /**
     * 是否申报(0-未申报,1-已申报)
     */
    protected Boolean isReport;
    private String isReportName;
    /**
     * 是否监管可见企业（0-否 1-是）
     */
    private Integer isRegulationVisible;
    /**
     * 数据来源,CompanyDataSourceEnum约定
     */
    protected Integer dataSource;
    private String dataSourceName;
    @ApiModelProperty(value = "数据来源ID（原ID）")
    private String dataSourceId;
    private String dataSourceDyId;
    @ApiModelProperty(value = "所属地区")
    private Long belongToRegion;

    /**
     * 去年接害人数统计
     */
    private String lastYearPickupCount;
    /**
     * 自查结果是否可靠企业(0-否,1-是)
     */
    protected Boolean isReliable;

    /**
     * 是否存在放射性
     */
    private Boolean isExistRadioactivity;

    /**
     * 是否监督对象
     */
    private Boolean isSupervise;
    private String isSuperviseName;
    /**
     * 是否粉尘一体化企业
     */
    private Boolean isFcyth;
    /**
     * 是否信用监管 否1是
     */
    private Integer creditSupervise;

    /**
     * 添加分类企业入库，佐证材料文件ids，逗号拼接。
     */
    @Transient
    private String storageFiles;

    /**
     * 添加分类企业入库，入库原因（申报导入1,举报投诉2,法定上报3,其他涉案4）。
     */
    @Transient
    private Integer storageReason;

    /**
     * 添加分类企业入库，入库时间。
     */
    @Transient
    private Date storageDate;

    public String getIsSuperviseName() {
        return CompanyIsSuperviseEnum.getName(isSupervise);
    }

    public String getIsDecName() {
        return CompanyIsDecEnum.getName(isDec);
    }

    public String getIsDecCurrentYearName() {
        return CompanyIsDecCurrentYearEnum.getName(isDecCurrentYear);
    }

    public String getIsReportName() {
        return CompanyIsReportEnum.getNameByValue(isReport);
    }

    public String getScaleName() {
        try {
            return CompanySizeEnum.getName(Integer.parseInt(scale));
        } catch (Exception e) {
            return "";
        }
    }

    public String getDataSourceName() {
        return CompanyDataSourceEnum.getName(dataSource);
    }

}
