package cn.smarthse.modules.datacentre.model;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 代理商企业信息model
 * @Description 
 * @Author liaoly
 * @Date 2020年3月10日 上午10:57:09
 */
public @Data class CompanyAgentModel implements Serializable {
	 
	private static final long serialVersionUID = -1298778354358821744L;
	
	/**
	 * 平台企业ID
	 */
	 private Long corpId;
	 
	 /**
     * 企业名称、医疗机构名称
     */
    private String fullname;

    /**
     * 企业简称
     */
    private String shortname;

    /**
     * 企业编号串(社会统一信代码/登记号/组织代码)
     */
    private String corpCc;
    
    /**
     * 联系人
     */
    private String corpApplyName;
    
    /**
     * 联系人电话
     */
    private String corpApplyMobile;
    
    /**
     * 注册时间
     */
    private Date regeditDate;
    
    /**
     * 格式化数据
     * 注册时间
     */
    private String regeditDateFormatter;
    
    /**
     * 联系电话
     */
    private String corpTel;
    
    /**
     * 企业邮箱
     */
    private String corpEmail;
    
    /**
     * 企业注册行政区域
     */
    private Long corpAreaId;
    
    /**
     * 通讯地址
     */
    private String corpAddress;
    
    /**
     * 所属行业Id
     * 
     * <li>1.3版本增加 by  shao
     */
    private Long corpTypeId;
    
    /**
     * 所属行业
     * <li>1.3版本增加 by  shao
     */
    private String corpTypeName;
	
}
