package cn.smarthse.modules.datacentre.enums.sysfile;

import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyBusinessState
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 12
 * @since 2019/12/19-14:12
 */
public enum SysFileConvertEnum {
    // 转换标记：0，默认无需转换， 1未转换， 2=转化中 3转换异常， 4已转完
    NONE("无需转换", 0),
    NEED("未转换", 1),
    CONVERTING("转化中", 2),
    ERROR("转换异常", 3),
    CONVERTED("已转完", 4),
    ;

    // 成员变量
    private String name;
    private Integer code;
    // 构造方法

    private SysFileConvertEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(Integer code) {
        if (code == null) {
            return "已关闭";
        }
        for (SysFileConvertEnum c : SysFileConvertEnum.values()) {
            if (Objects.equals(c.getCode(), code)) {
                return c.name;
            }
        }
        return "已关闭";
    }

    // 普通方法
    public static Integer getCodeByName(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (SysFileConvertEnum c : SysFileConvertEnum.values()) {
            if (c.getName().equals(name)) {
                return c.getCode();
            }
        }
        return null;
    }


    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
