package cn.smarthse.modules.datacentre.enums.apps;

import java.util.Objects;

/**
 * 
* 
* @ClassName: ProtectClassifyEnum.java
* @Description: 防护用品分类枚举
*
* @version: v1.0.0
* @author: cjy
* @date: 2019年1月14日 上午10:59:47 
*
* Modification History:
* Date         Author          Version            Description
*---------------------------------------------------------*
* 2019年1月14日      cjy          v1.0.0               修改原因
 */
public enum ProtectClassifyEnum {
	Head_Protect(1,"头部防护"),
	Feet_Protect(2,"足部防护"),
	Hands_Protect(3,"手部防护"),
	Face_Protect(4,"眼面防护"),
	Body_Protect(5,"躯干防护"),
	Noise_Protect(6,"听力防护"),
	Breathe_Protect(7,"呼吸防护"),
	Skin_Protect(8,"皮肤防护"),
	Falling_Protect(9,"坠落防护"),
	Other_Protect(10,"其他防护");
	
	private String name;
	
	private Integer id;

	private ProtectClassifyEnum(Integer id, String name) {
		this.id=id;
		this.name=name;
	}
	
	
	

		public String getName() {
		return name;
	}



	public void setName(String name) {
		this.name = name;
	}



	public Integer getId() {
		return id;
	}



	public void setId(Integer id) {
		this.id = id;
	}


	// 普通方法
	public static Integer getId(String name) {
		if (name == null) {
			return null;
		}
		for (ProtectClassifyEnum c : ProtectClassifyEnum.values()) {
			if (c.getName().equals(name)) {
				return c.id;
			}
		}
		return null;
	}

	// 普通方法
	public static String getName(Integer id) {
		if (id == null) {
			return "";
		}
		for (ProtectClassifyEnum c : ProtectClassifyEnum.values()) {
			if (Objects.equals(c.getId(), id)) {
				return c.name;
			}
		}
		return "类型不对";
	}
	
}
