package cn.smarthse.modules.datacentre.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 中止变更类型(0-无；1-拟暂停；2-拟关闭；31-拟跨地市；32-拟地市内；33-拟辖区内；4-拟恢复)
 *
 * @author chuhy
 * @date 2023/3/10 16:10
 */
@AllArgsConstructor
@Getter
public enum StopTypeEnums {

    /**
     * 0-无
     */
    NONE(0, "无"),
    /**
     * 1-企业暂停
     */
    PAUSE(1, "拟暂停"),
    /**
     * 2-企业关闭
     */
    CLOSE(2, "拟关闭"),
    /**
     * 3-区域变更
     */
    @Deprecated
    CHANGE(3, "拟迁移"),
    /**
     * 31-(区域变更-跨地市迁移)
     */
    CHANGECROSS(31, "跨地市迁移"),
    /**
     * 32-(区域变更-地市内迁移)
     */
    CHANGEWITHIN(32, "地市内迁移"),
    /**
     * 33-(区域变更-辖区内迁移)
     */
    CHANGEDISTRICTWITHIN(33, "辖区内迁移"),
    /**
     * 4-企业恢复(正常营业)
     */
    NORMAL(4, "拟恢复");

    private final Integer code;

    private final String name;

    public static String getNameByCode(Integer code) {
        Optional<StopTypeEnums> stopTypeEnums = Arrays.stream(StopTypeEnums.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (stopTypeEnums.isPresent()) {
            return stopTypeEnums.get().getName();
        }
        return "无";
    }
}
